import {postAxiosRequest, getAxiosRequest, putAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import {getAmazonInstanceUrl} from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `products`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchAmazonProducts = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const fetchAmazonProductById = (instanceId, id, params) => getAxiosRequest(getUrl(instanceId,`${id}`), {params})

export const downloadAmazonListings = (instanceId) => postAxiosRequest(getUrl(instanceId))

export const refreshAmazonProducts = (instanceId) => postAxiosRequest(getUrl(instanceId,`refresh`))

export const createAmazonSkuProduct = (instanceId, sendData, filters = {}) => {
  let params = {}
  if (filters && filters.conjunction) params.filters = JSON.stringify(filters)
  return postAxiosRequest(getUrl(instanceId,`create-sku-products`),sendData, {params})
}

export const fetchAmazonProductMapInfo = (instanceId) => getAxiosRequest(getUrl(instanceId, 'mapping-info'))

export const mapAmazonProduct = (instanceId, sendData) => putAxiosRequest(getUrl(instanceId, 'map'), sendData)

export const unmapAmazonProduct = (instanceId, query) => putAxiosRequest(getUrl(instanceId, `unmap?${query}`))

export const importAmazonProductMappings = (instanceId, sendData) => postAxiosRequest(getUrl(instanceId, 'import-mappings'), sendData)
