import {postAxiosRequest, getAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import {getAmazonInstanceUrl} from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `orders`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
} 

export const fetchAmazonOrders = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const fetchAmazonOrderById = (instanceId, id) => getAxiosRequest(getUrl(instanceId, `${id}`))

export const createAmazonSkuOrder = (instanceId, sendData) => postAxiosRequest(getUrl(instanceId, `create-sku-orders`), sendData)

export const downloadAmazonOrders = (instanceId) => postAxiosRequest(getUrl(instanceId, 'refresh'))
