import { postAxiosRequest, getAxiosRequest, putAxiosRequest, deleteAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getShipmentsUrl = (instanceId, path = '') => {
  const baseUrl = `new-inbound/shipments`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

const getPlansUrl = (instanceId, path = '') => {
  const baseUrl = `new-inbound/plans`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

const getInboundUrl = (instanceId, path = '') => {
  const baseUrl = `new-inbound`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const deleteAmazonInboundShipment = (instanceId, id) => deleteAxiosRequest(getShipmentsUrl(instanceId, `${id}`))

export const createAmazonInboundShipment = (instanceId, params) => postAxiosRequest(getShipmentsUrl(instanceId), params)

export const updateAmazonInboundShipment = (instanceId, id, params) => putAxiosRequest(getShipmentsUrl(instanceId, `${id}`), params)

export const fetchAmazonInboundShipmentById = (instanceId, id, params) => getAxiosRequest(getShipmentsUrl(instanceId, `${id}`), { params })

export const fetchAmazonInboundShipments = (instanceId, params) => getAxiosRequest(getShipmentsUrl(instanceId), buildUrlParams(params))

// // labels
// export const fetchAmazonInboundShipmentsLabels = (instanceId, id) => getAxiosRequest(getUrl(instanceId, `${id}/get-labels`))
//
// // bill of lading
// export const fetchAmazonInboundShipmentsBillLading = (instanceId, id) => getAxiosRequest(getUrl(instanceId, `${id}/get-bill-of-lading`))
//

export const fetchAmazonShipFromMappings = (instanceId, params = null) => getAxiosRequest(getInboundUrl(instanceId, 'ship-from-mappings'), { params })

export const updateAmazonShipFromMappings = (instanceId, params) => postAxiosRequest(getInboundUrl(instanceId, `ship-from-mappings`), params)

export const refresh = (instanceId) => postAxiosRequest(getPlansUrl(instanceId, `refresh`))
export const processAll = (instanceId) => postAxiosRequest(getShipmentsUrl(instanceId, `process-all`))
export const process = (instanceId, params) => postAxiosRequest(getShipmentsUrl(instanceId, `process`), params)
export const unprocess = (instanceId, params) => postAxiosRequest(getShipmentsUrl(instanceId, `unprocess`), params)

export const setSentBeforeInitialCount = (instanceId, params) => postAxiosRequest(getShipmentsUrl(instanceId, `set-sent-before-initial-count`), params)
