import { getAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `ledger-summaries/adjustments`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchAmazonInventoryLedgerSummaryAdjustments = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))
