import axiosConfig from '../config/axiosConfig'

const baseURL = '/addresses'

export const updateAddress = async ({ addressID, addressData }) => {
  const url = `${baseURL}/${addressID}`

  try {
    const { data } = await axiosConfig.put(url, { ...addressData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteAddress = async (addressID) => {
  const url = `${baseURL}/${addressID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
