import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'
import {deleteAxiosRequest, postAxiosRequest, putAxiosRequest} from '@/support/apiRequestHelpers'

const baseURL = '/accounting'

export const fetchPayments = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/payments`, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchTransactions = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/transactions`, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const syncExternal = async (options) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/transactions/sync-external`, options)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const syncPayments = async (options) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/payments/sync-external`, options)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getAccountingIntegration = async () => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/integration`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const refreshTransactions = async (options) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/transactions/refresh`, options)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchTransactionById = async (id) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/transactions/${id}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unlinkTransactions = async (payloads) => await postAxiosRequest(`${baseURL}/transactions/unlink-from-integration`, payloads)

export const bulkDeleteTransactions = async (payloads) => await deleteAxiosRequest(`${baseURL}/transactions`, {params: payloads})

export const deletePayments = async (payloads) => await postAxiosRequest(`${baseURL}/payments/delete-integration-payments`, payloads)

export const syncAccountingTransactions = async () => await postAxiosRequest(`${baseURL}/transactions/sync-all`)

export const clearAccountingTransactionErrors = async (payload) => await postAxiosRequest(`${baseURL}/transactions/clear-errors`, payload)

export const updateAccountingTransaction = async (id, payload) => await putAxiosRequest(`${baseURL}/transactions/${id}`, payload)

export const bulkReplaceNominalCodes = async (payload) => await postAxiosRequest(`${baseURL}/transactions/bulk-replace-nominal-codes`, payload)

export const destroyAccountingTransaction = async (id) => await deleteAxiosRequest(`${baseURL}/transactions/${id}`)

export const bulkEnableDisableSync = async (payload) => await postAxiosRequest(`${baseURL}/transactions/bulk-enable-sync`, payload)
