import { getChildren, getMeta } from '@/routes/routerHelpers'

const IntegrationsWoocommerce = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerce')
const IntegrationsWoocommerceInitialSetup = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceInitialSetup')
const IntegrationsWoocommerceDashboard = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceDashboard')
const IntegrationsWoocommerceOrderSettings = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceOrderSettings')
const IntegrationsWoocommerceOrders = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceOrders')
const IntegrationsWoocommerceListings = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceListings')
const IntegrationsWooCommerceAutoCreate = () => import('@/views/Integrations/woocommerce/IntegrationsWooCommerceAutoCreate')
const IntegrationsWoocommercePricing = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommercePricing')
const IntegrationsWoocommerceInventory = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceInventory')
const IntegrationsWoocommerceSettings = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceSettings')
const IntegrationsWoocommerceConnection = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceConnection')
const IntegrationsWoocommerceShipping = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceShipping')
const IntegrationsWoocommerceFinalize = () => import('@/views/Integrations/woocommerce/IntegrationsWoocommerceFinalize')

const INTEGRATION_NAME = 'Woocommerce'

const getPath = (segments, withInstanceId = true, isInitial = false) => {
  let prefix = isInitial ? '/integrations' : '/integrations/woocommerce'
  if (withInstanceId) prefix += '/:instanceId'
  return `${prefix}/${segments}`
}
const getRouteName = (name = '') => `${INTEGRATION_NAME} ${name}`

const childrenList = [
  { name: 'Dashboard', path: 'dashboard', component: IntegrationsWoocommerceDashboard, },
  { name: 'Orders Settings', path: 'orders-settings', component: IntegrationsWoocommerceOrderSettings, },
  { name: 'Orders', path: 'orders', component: IntegrationsWoocommerceOrders, },
  { name: 'Mapping', path: 'mapping', component: IntegrationsWoocommerceListings, },
  { name: 'Auto Create', path: 'auto-create', component: IntegrationsWooCommerceAutoCreate, },
  { name: 'Pricing', path: 'pricing', component: IntegrationsWoocommercePricing, },
  { name: 'Inventory', path: 'inventory', component: IntegrationsWoocommerceInventory, },
  { name: 'Settings', path: 'settings', component: IntegrationsWoocommerceSettings, },
  { name: 'Connection', path: 'connection', component: IntegrationsWoocommerceConnection, },
  { name: 'Shipping', path: 'shipping', component: IntegrationsWoocommerceShipping, },
  { name: 'Finalize', path: 'finalize', component: IntegrationsWoocommerceFinalize, },
]

export const wooCommerceRoutes = (() => {
  return [
    {
      path: getPath('initial-setup-woocommerce', false, true),
      name: getRouteName('Initial Setup'),
      component: IntegrationsWoocommerceInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: INTEGRATION_NAME,
          disabled: true
        }
      }
    },
    {
      path: '/integrations/woocommerce/:instanceId',
      name: getRouteName(),
      component: IntegrationsWoocommerce,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    },
  ]
})()
