import {getChildren, getMeta} from '@/routes/routerHelpers'

const IntegrationsShipMyOrders = () => import('@/views/Integrations/shipmyorders/IntegrationsShipMyOrders')
const IntegrationsShipMyOrdersInitialSetup = () => import('@/views/Integrations/shipmyorders/IntegrationsShipMyOrdersInitialSetup')
const IntegrationsShipMyOrdersDashboard = () => import('@/views/Integrations/shipmyorders/IntegrationsShipMyOrdersDashboard')
const IntegrationsShipMyOrdersInventoryDiscrepancies = () => import('@/views/Integrations/shipmyorders/inventory/IntegrationsShipMyOrdersInventoryDiscrepancies')
const IntegrationsShipMyOrdersInventoryWithoutSkuProducts = () => import('@/views/Integrations/shipmyorders/inventory/IntegrationsShipMyOrdersInventoryWithoutSkuProducts')
const IntegrationsShipMyOrdersInventoryWithoutSmoInventory = () => import('@/views/Integrations/shipmyorders/inventory/IntegrationsShipMyOrdersInventoryWithoutSmoInventory')
const IntegrationsShipMyOrdersConnections = () => import('@/views/Integrations/shipmyorders/IntegrationsShipMyOrdersConnections')
const IntegrationsShipMyOrdersSettings = () => import('@/views/Integrations/shipmyorders/IntegrationsShipMyOrdersSettings')
const IntegrationsShipMyOrdersInvoices = () => import('@/views/Integrations/shipmyorders/invoices/ShipMyOrdersInvoicesView')
const IntegrationsShipMyOrdersInvoiceAccountingRules = () => import('@/views/Integrations/shipmyorders/invoices/ShipMyOrdersInvoiceAccountingRules')

const INTEGRATION_NAME = 'ShipMyOrders'
const INTEGRATION_PATH_NAME = 'shipmyorders'

const getPath = (segments, withInstanceId = true, isInitial = false) => {
  let prefix = isInitial ? '/integrations' : `/integrations/${INTEGRATION_PATH_NAME}`
  if (withInstanceId) prefix += '/:instanceId'
  return `${prefix}/${segments}`
}
const getRouteName = (name = '') => `${INTEGRATION_NAME} ${name}`

const childrenList = [
  { name: 'Dashboard', path: 'dashboard', component: IntegrationsShipMyOrdersDashboard },
  { name: 'Settings', path: 'settings', component: IntegrationsShipMyOrdersSettings },
  { name: 'Connection', path: 'connection', component: IntegrationsShipMyOrdersConnections },
  { name: 'Inventory Discrepancies', path: 'inventory/discrepancies', component: IntegrationsShipMyOrdersInventoryDiscrepancies },
  { name: 'Inventory Without SKU Products', path: 'inventory/without-sku-products', component: IntegrationsShipMyOrdersInventoryWithoutSkuProducts },
  { name: 'Inventory Without SMO Inventory', path: 'inventory/without-smo-inventory', component: IntegrationsShipMyOrdersInventoryWithoutSmoInventory },
  { name: 'Invoices', path: 'invoices', component: IntegrationsShipMyOrdersInvoices },
  { name: 'Invoice Accounting Rules', path: 'accounting-rules', component: IntegrationsShipMyOrdersInvoiceAccountingRules }
]

export const shipMyOrdersIntegrationsRoutes = (() => {
  return [
    {
      path: getPath(`initial-setup-${INTEGRATION_PATH_NAME}`, false, true),
      name: getRouteName('Initial Setup'),
      component: IntegrationsShipMyOrdersInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: INTEGRATION_NAME,
          disabled: true
        }
      }
    },
    {
      path: `/integrations/${INTEGRATION_PATH_NAME}/:instanceId`,
      name: getRouteName(),
      component: IntegrationsShipMyOrders,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    }
  ]
})()
