// Starshipit
const IntegrationsStarshipit = () => import('@/views/Integrations/starshipit/IntegrationsStarshipit')
const IntegrationsStarshipitInitialSetup = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitInitialSetup')
const IntegrationsStarshipitDashboard = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitDashboard')
const IntegrationsStarshipitFulfillment = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitFulfillment')
const IntegrationsStarshipitShipping = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitShipping')
const IntegrationsStarshipitConnections = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitConnections')
const IntegrationsStarshipitActionsLog = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitActionsLog')
const IntegrationsStarshipitErrorsLog = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitErrorsLog')
const IntegrationsStarshipitSettings = () => import('@/views/Integrations/starshipit/IntegrationsStarshipitSettings')

export const starshipitRoutes = (() => {
  return [
    // Starshipit
    {
      path: '/integrations/initial-setup-starshipit',
      name: 'Starshipit Initial Setup',
      component: IntegrationsStarshipitInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: 'Starshipit',
          disabled: true
        }
      }
    },
    {
      path: '/integrations/starshipit/:instanceId',
      name: 'Starshipit',
      component: IntegrationsStarshipit,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: [
        {
          path: '/integrations/starshipit/:instanceId/dashboard',
          name: 'Starshipit Dashboard',
          component: IntegrationsStarshipitDashboard,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/starshipit/:instanceId/fulfillment',
          name: 'Starshipit Fulfillment',
          component: IntegrationsStarshipitFulfillment,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/starshipit/:instanceId/shipping',
          name: 'Starshipit Shipping',
          component: IntegrationsStarshipitShipping,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/starshipit/:instanceId/connection',
          name: 'Starshipit Connection',
          component: IntegrationsStarshipitConnections,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/starshipit/:instanceId/actions-log',
          name: 'Starshipit Actions Log',
          component: IntegrationsStarshipitActionsLog,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/starshipit/:instanceId/errors-log',
          name: 'Starshipit Errors Log',
          component: IntegrationsStarshipitErrorsLog,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/starshipit/:instanceId/settings',
          name: 'Starshipit Settings',
          component: IntegrationsStarshipitSettings,
          meta: {
            requiresWizardDone: false
          }
        }
      ]
    }
  ]
})()
