// Magento
const IntegrationsMagento = () => import('@/views/Integrations/magento/IntegrationsMagento')
const IntegrationsMagentoInitialSetup = () => import('@/views/Integrations/magento/IntegrationsMagentoInitialSetup')
const IntegrationsMagentoAutoCreate = () => import('@/views/Integrations/magento/IntegrationsMagentoAutoCreate')
const IntegrationsMagentoDashboard = () => import('@/views/Integrations/magento/IntegrationsMagentoDashboard')
const IntegrationsMagentoInventory = () => import('@/views/Integrations/magento/IntegrationsMagentoInventory')
const IntegrationsMagentoListings = () => import('@/views/Integrations/magento/IntegrationsMagentoListings')
const IntegrationsMagentoPricing = () => import('@/views/Integrations/magento/IntegrationsMagentoPricing')
const IntegrationsMagentoConnection = () => import('@/views/Integrations/magento/IntegrationsMagentoConnection')
const IntegrationsMagentoOrders = () => import('@/views/Integrations/magento/IntegrationsMagentoOrders')
const IntegrationsMagentoOrdersSettings = () => import('@/views/Integrations/magento/IntegrationsMagentoOrdersSettings')
const IntegrationsMagentoSettings = () => import('@/views/Integrations/magento/IntegrationsMagentoSettings')
const IntegrationsMagentoShipping = () => import('@/views/Integrations/magento/IntegrationsMagentoShipping')
const IntegrationsMagentoPayments = () => import('@/views/Integrations/magento/IntegrationsMagentoPayments')
const IntegrationMagentoStores = () => import('@/views/Integrations/magento/IntegrationsMagentoStores')
const IntegrationsMagentoFinalize = () => import('@/views/Integrations/magento/IntegrationsMagentoFinalize')

export const magentoRoutes = (() => {
  return [
    // Magento
    {
      path: '/integrations/initial-setup-magento',
      name: 'Magento Initial Setup',
      component: IntegrationsMagentoInitialSetup,
      meta: {
        requiresWizardDone: false
      }
    },
    {
      path: '/integrations/magento/:instanceId',
      name: 'Magento',
      component: IntegrationsMagento,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: [
        {
          path: '/integrations/magento/:instanceId/dashboard',
          name: 'Magento Dashboard',
          component: IntegrationsMagentoDashboard,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/mapping',
          name: 'Magento Mapping',
          component: IntegrationsMagentoListings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/pricing',
          name: 'Magento Pricing',
          component: IntegrationsMagentoPricing,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/inventory',
          name: 'Magento Inventory',
          component: IntegrationsMagentoInventory,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/auto-create',
          name: 'Magento Auto Create',
          component: IntegrationsMagentoAutoCreate,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/orders',
          name: 'Magento Orders',
          component: IntegrationsMagentoOrders,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/orders-settings',
          name: 'Magento Orders Settings',
          component: IntegrationsMagentoOrdersSettings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/settings',
          name: 'Magento Settings',
          component: IntegrationsMagentoSettings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/shipping',
          name: 'Magento Shipping',
          component: IntegrationsMagentoShipping,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/connection',
          name: 'Magento Connection',
          component: IntegrationsMagentoConnection,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/payment-method-mappings',
          name: 'Magento Payment Method Mappings',
          component: IntegrationsMagentoPayments,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/store-mappings',
          name: 'Magento Store Mappings',
          component: IntegrationMagentoStores,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/magento/:instanceId/finalize',
          name: 'Magento Finalize',
          component: IntegrationsMagentoFinalize,
          meta: {
            requiresWizardDone: false
          }
        }
      ]
    }
  ]
})()
