// QuickBooks
const IntegrationsQuickBooks = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooks')
const IntegrationsQuickBooksInitialSetup = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksInitialSetup')
const IntegrationsQuickBooksDashboard = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksDashboard')
const IntegrationsQuickBooksPaymentMethodsMapping = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksPaymentMethodsMapping')
const IntegrationsQuickBooksSettings = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksSettings')
const IntegrationsQuickBooksConnection = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksConnection')
const IntegrationsQuickBooksConsolidation = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksConsolidation')
const IntegrationsQuickBooksTaxRates = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksTaxRates')
const IntegrationsQuickBooksSuppliersCustomers = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksSuppliersCustomers')
const IntegrationsQuickBooksFinalizeOAuth = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksFinalizeOAuth')
const IntegrationsQuickBooksErrorsLog = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksErrorsLog')
// const IntegrationsQuickBooksPayments = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksPayments')
const IntegrationsQuickBooksAccounts = () => import('@/views/Integrations/quickbooks/IntegrationsQuickBooksAccounts')

export const quickBooksRoutes = (() => {
  return [
    {
      path: '/integrations/initial-setup-quickbooks-online',
      name: 'QuickBooks Initial Setup',
      component: IntegrationsQuickBooksInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: 'QuickBooks',
          disabled: true
        }
      }
    },
    {
      path: '/integrations/quickbooks-online/:instanceId',
      name: 'QuickBooks',
      component: IntegrationsQuickBooks,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: [
        {
          path: '/integrations/quickbooks-online/:instanceId/dashboard',
          name: 'QuickBooks Dashboard',
          component: IntegrationsQuickBooksDashboard,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/consolidation',
          name: 'QuickBooks Consolidation',
          component: IntegrationsQuickBooksConsolidation,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/tax-rates',
          name: 'QuickBooks Tax Rate Mappings',
          component: IntegrationsQuickBooksTaxRates,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/contacts',
          name: 'QuickBooks Contacts',
          component: IntegrationsQuickBooksSuppliersCustomers,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/errors-log',
          name: 'QuickBooks Errors Log',
          component: IntegrationsQuickBooksErrorsLog,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/connection',
          name: 'QuickBooks Connection',
          component: IntegrationsQuickBooksConnection,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/settings',
          name: 'QuickBooks Settings',
          component: IntegrationsQuickBooksSettings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/payment-methods-mapping',
          name: 'QuickBooks Payment Methods Mapping',
          component: IntegrationsQuickBooksPaymentMethodsMapping,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/finalize',
          name: 'QuickBooks Finalize',
          component: IntegrationsQuickBooksFinalizeOAuth,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/quickbooks-online/:instanceId/accounts',
          name: 'QuickBooks Payments',
          component: IntegrationsQuickBooksAccounts,
          meta: {
            requiresWizardDone: false
          }
        }
      ]
    }
  ]
})()
