import { getChildren, getMeta } from '@/routes/routerHelpers'

const IntegrationsEbay = () => import('@/views/Integrations/ebay/IntegrationsEbay')
const IntegrationsEbayFinalize = () => import('@/views/Integrations/ebay/IntegrationsEbayFinalize')
const IntegrationsEbayDashboard = () => import('@/views/Integrations/ebay/IntegrationsEbayDashboard')
const IntegrationsEbayConnection = () => import('@/views/Integrations/ebay/IntegrationsEbayConnection')
const IntegrationsEbayInitialSetup = () => import('@/views/Integrations/ebay/IntegrationsEbayInitialSetup')
const IntegrationsEbaySettings = () => import('@/views/Integrations/ebay/IntegrationsEbaySettings')
const IntegrationsEbayShipping = () => import('@/views/Integrations/ebay/IntegrationsEbayShipping')
const IntegrationsEbayInventory = () => import('@/views/Integrations/ebay/IntegrationsEbayInventory')
const IntegrationsEbayListings = () => import('@/views/Integrations/ebay/IntegrationsEbayListings')
const IntegrationsEbayAutoCreate = () => import('@/views/Integrations/ebay/IntegrationsEbayAutoCreate')
const IntegrationsEbayOrders = () => import('@/views/Integrations/ebay/IntegrationsEbayOrders')
const IntegrationsEbayPricing = () => import('@/views/Integrations/ebay/IntegrationsEbayPricing')
const IntegrationsEbayOrdersSettings = () => import('@/views/Integrations/ebay/IntegrationsEbayOrdersSettings')

const INTEGRATION_NAME = 'Ebay'
const INTEGRATION_NAME_SLUG = 'ebay'

const getPath = (segments, withInstanceId = true, isInitial = false) => {
  let prefix = isInitial ? '/integrations' : `/integrations/${INTEGRATION_NAME_SLUG}`
  if (withInstanceId) prefix += '/:instanceId'
  return `${prefix}/${segments}`
}
const getRouteName = (name = '') => `${INTEGRATION_NAME} ${name}`

const childrenList = [
  { name: 'Dashboard', path: 'dashboard', component: IntegrationsEbayDashboard, },
  { name: 'Orders Settings', path: 'orders-settings', component: IntegrationsEbayOrdersSettings, },
  { name: 'Orders', path: 'orders', component: IntegrationsEbayOrders, },
  { name: 'Mapping', path: 'mapping', component: IntegrationsEbayListings, },
  { name: 'Auto Create', path: 'auto-create', component: IntegrationsEbayAutoCreate, },
  { name: 'Pricing', path: 'pricing', component: IntegrationsEbayPricing, },
  { name: 'Inventory', path: 'inventory', component: IntegrationsEbayInventory, },
  { name: 'Settings', path: 'settings', component: IntegrationsEbaySettings, },
  { name: 'Connection', path: 'connection', component: IntegrationsEbayConnection, },
  { name: 'Shipping', path: 'shipping', component: IntegrationsEbayShipping, },
  { name: 'Finalize', path: 'finalize', component: IntegrationsEbayFinalize, },
]

export const ebayRoutes = (() => {
  return [
    {
      path: getPath(`initial-setup-${INTEGRATION_NAME_SLUG}`, false, true),
      name: getRouteName('Initial Setup'),
      component: IntegrationsEbayInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: INTEGRATION_NAME,
          disabled: true
        }
      }
    },
    {
      path: `/integrations/${INTEGRATION_NAME_SLUG}/:instanceId`,
      name: getRouteName(),
      component: IntegrationsEbay,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    },
  ]
})()
