import SKUGlobalSearch from './SKUGlobalSearch.vue'
import { debounce } from 'lodash'

export default {
  install (Vue, store) {
    // Register module when installing the plugin
    store.registerModule('SKUGlobalSearchModule', SKUGlobalSearchModule)

    // Register the Global search component globally
    Vue.component('SKUGlobalSearch', SKUGlobalSearch)

    // Registering Global Search Directive
    Vue.directive('global-search', {
      bind: (el) => {
        // Debouncer
        el.addEventListener('input', debounce(e => e, 500))

        // Disable Global Search on Focus
        el.addEventListener('focus', () => {
          store.dispatch('SKUGlobalSearchModule/setCanGlobalSearch', false)
        })

        // Enable Global Search on Blur
        el.addEventListener('blur', () => {
          store.dispatch('SKUGlobalSearchModule/setCanGlobalSearch', true)
        })
      }
    })

    // Add openGlobalSearch to the Vue prototype
    Vue.prototype.$openGlobalSearch = (options) => {
      store.dispatch('SKUGlobalSearchModule/openGlobalSearch', options)
    }
    // Add closeGlobalSearch to the Vue prototype
    Vue.prototype.$closeGlobalSearch = (options) => {
      store.dispatch('SKUGlobalSearchModule/closeGlobalSearch', options)
    }
  }
}

const SKUGlobalSearchModule = {
  namespaced: true,
  state: {
    visible: false,
    canGlobalSearch: true
  },
  getters: {
    isVisible: state => state.visible,
    canGlobalSearch: state => state.canGlobalSearch
  },
  mutations: {
    // Open global search dialog mutation
    OPEN_GLOBAL_SEARCH (state, options) {
      state.visible = true
    },
    // Close global search dialog mutation
    CLOSE_GLOBAL_SEARCH (state, options) {
      state.visible = false
    },
    // Make the global search available mutation
    SET_CAN_GLOBAL_SEARCH (state, value) {
      state.canGlobalSearch = value
    }
  },
  actions: {
    // Open global search action
    openGlobalSearch ({ commit }, options) {
      commit('OPEN_GLOBAL_SEARCH', options)
    },
    // Close global search action
    closeGlobalSearch ({ commit }, options) {
      commit('CLOSE_GLOBAL_SEARCH', options)
    },
    // Make the global search available action
    setCanGlobalSearch ({ commit }, value) {
      commit('SET_CAN_GLOBAL_SEARCH', value)
    }
  }
}
