import { cloneDeep, isEqual } from 'lodash'
import showErrors from '@/support/showErrors'

export default {
  computed: {
    hasSomethingChanged () {
      return !isEqual(this.editedValues, this.initialValues)
    }
  },
  data () {
    return {
      initialValues: {},
      isProcessing: false
    }
  },
  methods: {
    setInitialValues (data) {
      this.initialValues = cloneDeep(data)
      return cloneDeep(this.initialValues)
    },
    revertChanges () {
      this.editedValues = cloneDeep(this.initialValues)
    },
    async saveHandler () {
      this.isProcessing = true
      try {
        await this.save()
        this.$notification.$emit('success')
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.isProcessing = false
      }
    }
  }
}
