// depends on tableInitMixin

import { mapGetters } from 'vuex'
import showErrors from '@/support/showErrors'
import { createStockTake } from '../services/ProductsService'
import { openStockTakeDrawer } from '@/support/drawerHelper'
// passing methods to the mixin has caveats. it's better to add such methods in a component and then use in the mixin
// caveat: such methods won't have access to 'this' because 'this' is not defined at the moment they are been passed to the mixin

export default ({
  storeNamespace = () => (console.log('storeNamespace not provided for tableDeleteMixin')),
  archiveItemById = false,
  unarchiveItemById = false,
  syncItemById = false,
  archiveItems = false,
  unarchiveItems = false,
  syncItems = false,
  deleteItemById = false,
  deleteItems = false,
  isDeletable = false,
  isArchivable = false,
  createStockTake = false,
  identifier = 'id',
  isAlwaysDeletable = false
} = {}) => {
  return {
    data () {
      return {
        deleteModalMode: 'delete', // or 'archive'
        selectedRowForDelete: {},
        selectedRowsForDelete: [],
        selectedAllRows: false,
        showDeleteModal: false,
        archiveLoading: false,
        unarchiveLoading: false,
        syncLoading: false,
        deleteLoading: false,
        warningList: null,
        deleted: false
      }
    },
    computed: {
      ...mapGetters(storeNamespace, ['getFilteringCriteria', 'getShowArchivedItems'])
    },
    methods: {
      openStockTakeModal ({ row, rows, selectedAllRows, warehouseId }) {
        this.resetValues()
        this.assignStockTakeValues({ row, rows, selectedAllRows, warehouseId })
      },
      assignStockTakeValues ({ row, rows, selectedAllRows, warehouseId }) {
        if (selectedAllRows === false || selectedAllRows === true) {
          this.selectedAllRows = selectedAllRows
        }

        let productIds = []
        if (rows && rows.length) { // when multiple rows are to be deleted
          this.selectedRowsForDelete = rows.map(r => {
            r.deletable = true
            return r
          })

          // this.loading is from tableInitMixin
          this.loading = true
          // check deletable status of each row
          productIds = rows.map(r => r[identifier])
        } else if (row) { // when 1 row is to be deleted
          this.selectedRowForDelete = row
          this.selectedRowForDelete.deletable = true
          this.selectedRowForDelete.reasons = {}

          // this.loading is from tableInitMixin
          this.loading = true

          // check deletable status of selected row
          // for some reason async await didn't work here for shopify integrations

          productIds = r.find(
            i => String(i.id) === String(row[identifier]))
        }

        //
        this.createStockTakeMixinMethod(productIds, warehouseId).then(result => {
          this.loading = false
          openStockTakeDrawer(this, result.stock_take_id, 'view', false)
        })

        // this.$router.push('/inventory/stock-takes')
      },
      // we diplicate this methods for cases where we might need to rewrite them from the component which uses the mixin
      // this is a hack to prevent refactoring of all existing usecases where there was no need to modify this methods
      // from the component
      createStockTakeMixinMethod (ids, warehouseId) {
        return createStockTake(ids, warehouseId)
      },
      archiveItemByIdMixinMethod (data) {
        return archiveItemById(data)
      },
      unarchiveItemByIdMixinMethod (data) {
        return unarchiveItemById(data)
      },
      archiveItemsMixinMethod (data) {
        return archiveItems(data)
      },
      unarchiveItemsMixinMethod (data) {
        return unarchiveItems(data)
      },
      syncItemsMixinMethod (data) {
        return syncItems(data)
      },
      syncItemByIdMixinMethod (data) {
        return syncItemById(data)
      },
      deleteItemByIdMixinMethod (data) {
        return deleteItemById(data)
      },
      deleteItemsMixinMethod (data) {
        return deleteItems(data)
      },
      isDeletableMixinMethod (data) {
        return isDeletable(data)
      },
      isArchivableMixinMethod (data) {
        return isArchivable(data)
      },

      resetValues () {
        this.selectedRowForDelete = {}
        this.selectedRowsForDelete = []
        this.selectedAllRows = false
      },
      openDeleteModal ({ row, rows, selectedAllRows }) {
        this.resetValues()
        this.assignDeleteValues({ row, rows, selectedAllRows })
      },
      assignDeleteValues ({ row, rows, selectedAllRows }) {
        if (selectedAllRows === false || selectedAllRows === true) {
          this.selectedAllRows = selectedAllRows
        }
        if (rows && rows.length) { // when multiple rows are to be deleted
          this.selectedRowsForDelete = rows.map(r => {
            r.deletable = true
            return r
          })
          if (isDeletable) {
            // this.loading is from tableInitMixin
            this.loading = true
            // check deletable status of each row
            // for some reason async await didn't work here for shopify integrations
            this.isDeletable(rows.map(r => r[identifier])).then(r => {
              this.selectedRowsForDelete.forEach((row, index) => {
                const deletableItem = r.find(deletable => String(deletable.id) === String(row[identifier]))

                row.deletable = deletableItem.deletable
                row.reasons = deletableItem.reason
                row.warnings = deletableItem.warnings

                row = JSON.parse(JSON.stringify(row))

                this.deleteModalMode = 'delete'
                this.showDeleteModal = true
              })
            }).catch(e => {
              showErrors.call(this, e)
            }).finally(r => {
              this.loading = false
            })
          } else if (isAlwaysDeletable) this.showDeleteModal = true

        } else if (row) { // when 1 row is to be deleted
          this.selectedRowForDelete = row
          this.selectedRowForDelete.deletable = true
          this.selectedRowForDelete.reasons = {}
          if (isDeletable) {
            // this.loading is from tableInitMixin
            this.loading = true
            // check deletable status of selected row
            // for some reason async await didn't work here for shopify integrations
            this.isDeletable([row[identifier]]).then(r => {
              const deletableItem = r.find(i => String(i.id) === String(row[identifier]))

              this.selectedRowForDelete.deletable = deletableItem.deletable
              this.selectedRowForDelete.reasons = deletableItem.reason
              this.selectedRowForDelete.warnings = deletableItem.warnings

              this.selectedRowForDelete = JSON.parse(JSON.stringify(this.selectedRowForDelete))

              this.deleteModalMode = 'delete'
              this.showDeleteModal = true
            }).catch(e => {
              showErrors.call(this, e)
            }).finally(r => {
              this.loading = false
            })
          } else if (isAlwaysDeletable) this.showDeleteModal = true

        }
      },
      async openArchiveModal ({ row, rows, selectedAllRows }) {
        this.resetValues()
        await this.assignValuesForArchiveModals({ row, rows, selectedAllRows })

        this.deleteModalMode = 'archive'
        this.showDeleteModal = true
      },
      openUnarchiveModal ({ row, rows, selectedAllRows }) {
        this.resetValues()
        this.assignValuesForArchiveModals({ row, rows, selectedAllRows })

        this.deleteModalMode = 'unarchive'
        this.showDeleteModal = true
      },
      openSyncModal ({ row, rows, selectedAllRows }) {
        this.resetValues()
        this.assignValuesForArchiveModals({ row, rows, selectedAllRows })

        this.deleteModalMode = 'sync'
        this.showDeleteModal = true
      },
      async assignValuesForArchiveModals ({ row, rows, selectedAllRows }) {
        if (selectedAllRows === false || selectedAllRows === true) {
          this.selectedAllRows = selectedAllRows
        }
        if (rows && rows.length) { // when multiple rows are to be archived
          this.selectedRowsForDelete = rows.map(r => {
            r.archivable = true
            return r
          })
          if (isArchivable) {
            try {
              // this.loading is from tableInitMixin
              this.loading = true
              // check deletable status of each row
              const archivableArray = await this.isArchivable(rows.map(r => r[identifier]))

              this.selectedRowsForDelete.forEach((row, index) => {
                const archivableItem = archivableArray.find(archivable => archivable[identifier] === row[identifier])
                row.archivable = archivableItem.archivable
                row.reasons = archivableItem.reason
              })
            } catch (e) {
              showErrors.call(this, e)
            } finally {
              this.loading = false
            }
          }
        } else if (row) { // when 1 row is to be archived
          this.selectedRowForDelete = row
          this.selectedRowForDelete.archivable = true
          this.selectedRowForDelete.reasons = {}
          if (isArchivable) {
            try {
              // this.loading is from tableInitMixin
              this.loading = true

              // check deletable status of selected row
              const archivableArray = await this.isArchivable([row[identifier]])
              const archivableItem = archivableArray.find(i => i[identifier] === row[identifier])

              this.selectedRowForDelete.archivable = archivableItem.archivable
              this.selectedRowForDelete.reasons = archivableItem.reason
            } catch (e) {
              showErrors.call(this, e)
            } finally {
              this.loading = false
            }
          }
        }
      },
      closeDeleteModal () {
        this.showDeleteModal = false
        this.reset()
      },
      archiveItemsHandler (items) {
        if (this.selectedAllRows || items.length) {
          this.archiveSelectedItems(items)
        } else {
          this.archiveItem()
        }
      },
      unarchiveItemsHandler (items) {
        if (this.selectedAllRows || items.length) {
          this.unarchiveItems(items)
        } else if (items.length === 1) {
          this.unarchiveItem(items[0])
        }
      },
      deleteItemsHandler (items) {
        if (this.selectedAllRows || items.length) {
          this.deleteSelectedItems(items)
        } else {
          this.deleteItem()
        }
      },
      syncItemsHandler (items) {
        if (this.selectedAllRows || items.length) {
          this.syncSelectedItems(items)
        } else {
          this.syncItem()
        }
      },
      async syncSelectedItems (items) {
        if (this.syncLoading) return
        try {
          this.syncLoading = true

          let sendData = {}
          if (!this.selectedAllRows) {
            sendData.ids = items.map(i => i[identifier])
          } else {
            sendData.filters = JSON.stringify(this.getFilteringCriteria)
          }

          await this.syncItemsMixinMethod(sendData)
          this.finalizeRequest()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.syncLoading = false
        }
      },
      async syncItem () {
        try {
          this.syncLoading = true
          await this.syncItemByIdMixinMethod(this.selectedRowForDelete[identifier])

          this.finalizeRequest()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.syncLoading = false
        }
      },
      setDeletedValue () {
        this.deleted = true
        this.$nextTick(() => {
          this.deleted = false
        })
      },
      async archiveSelectedItems (items) {
        if (this.archiveLoading) return
        try {
          this.archiveLoading = true

          let sendData = {}
          if (!this.selectedAllRows) {
            sendData.ids = items.map(i => i[identifier])
          } else {
            sendData.filters = JSON.stringify(this.getFilteringCriteria)
          }

          await this.archiveItemsMixinMethod(sendData)
          this.finalizeRequest()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.archiveLoading = false
        }
      },
      async archiveItem () {
        try {
          this.archiveLoading = true
          await this.archiveItemByIdMixinMethod(this.selectedRowForDelete[identifier])

          this.finalizeRequest()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.archiveLoading = false
        }
      },
      async unarchiveItem (item) {
        try {
          this.unarchiveLoading = true
          await this.unarchiveItemByIdMixinMethod(item[identifier])

          this.finalizeRequest()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.unarchiveLoading = false
        }
      },
      async unarchiveItems (items) {
        if (this.unarchiveLoading) return
        try {
          this.unarchiveLoading = true

          let sendData = {}
          if (!this.selectedAllRows) {
            sendData.ids = items.map(i => i[identifier])
          } else {
            sendData.filters = JSON.stringify(this.getFilteringCriteria)
          }

          await this.unarchiveItemsMixinMethod(sendData)
          this.finalizeRequest()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.unarchiveLoading = false
        }
      },
      async deleteSelectedItems (items) {
        if (this.deleteLoading) return
        try {
          this.deleteLoading = true

          let sendData = {}
          if (!this.selectedAllRows) {
            sendData.ids = items.map(i => i[identifier])
          } else {
            sendData.filters = JSON.stringify(this.getFilteringCriteria)
          }

          if (this.getShowArchivedItems) { sendData.archived = 1 }
          // sendData.archived = this.getShowArchivedItems ? 1 : 0

          const response = await this.deleteItemsMixinMethod(sendData)
          if (response?.status === 'success') this.$notification.$emit('success', { html: 'Records were deleted successfully.' })
          if (response?.data?.hasOwnProperty('warnings')) this.warningList = response.data.warnings
          this.finalizeRequest()
          this.setDeletedValue()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.deleteLoading = false
        }
      },
      async deleteItem () {
        if (this.deleteLoading) return
        try {
          this.deleteLoading = true

          await this.deleteItemByIdMixinMethod(this.selectedRowForDelete[identifier])
          this.finalizeRequest()
          this.setDeletedValue()
        } catch (e) {
          showErrors.call(this, e)
        } finally {
          this.deleteLoading = false
        }
      },
      finalizeRequest () {
        this.showDeleteModal = false
        this.closeDeleteModal()
        // method from tableInitMixin
        this.reloadData()
      },
      async isDeletable (ids) {
        try {
          const response = await this.isDeletableMixinMethod(ids)
          return response.data
        } catch (e) {
          showErrors.call(this, e)
        }
      },
      async isArchivable (ids) {
        try {
          const response = await this.isArchivableMixinMethod(ids)
          return response.data
        } catch (e) {
          showErrors.call(this, e)
        }
      },

      reset () {
        this.deleteModalMode = 'delete'
        this.selectedRowForDelete = {}
        this.selectedRowsForDelete = []
        this.selectedAllRows = false
      }
    }
  }
}
