import showErrors from '@/support/showErrors'
import { showAlert } from '@/support/helpers'

export default {
  data() {
    return {
      paymentSaving: false
    }
  },
  methods: {
    async submitPayment (payment) {
      this.paymentSaving = true
      try {
        const response = payment.id ?
          await this.editPayment(payment) :
          await this.addPayment(payment.payment)

        showAlert(this, { type: 'success', html: `${payment.payment.amount < 0 ? 'Refund' : 'Payment'} ${response}` })
        // Close the modal
        this.closePaymentModal()
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.paymentSaving = false
      }
    }
  }
}
