import { updateStockTake } from '@/services/StockTakesService'
import showErrors from '@/support/showErrors'

export default {
  methods: {
    async saveStockTake () {
      const payload = {
        date_count: this.getEditingItem.date_count,
        notes: this.getEditingItem.notes,
      }

      if (this.getEditingItem.status !== 'closed') {
        payload.warehouse_id = this.getEditingItem.warehouse.id
        payload.items = this.getEditingItem.items.map(current => {
          current.product_id = current.item_product_id

          if (!current.qty_counted) {
            delete current.qty_counted
          }

          if (Number(current.item_unit_cost) === current.item_unit_cost_original) {
            delete current.item_unit_cost
          } else {
            current.unit_cost = current.item_unit_cost
          }

          if (!current.unit_cost) {
            delete current.unit_cost
          }

          return current
        })
      } else {
        payload.items = this.getEditingItem.items.map(current => {
          return {
            product_id: current.item_product_id,
            quantity: current.item_quantity,
            unit_cost: current.item_unit_cost,
            to_delete: current.to_delete
          }
        })
      }

      try {
        return await updateStockTake(this.getEditingItem.id, payload)
      } catch (e) {
        showErrors.call(this, e)
        return false
      }
    }
  }
}
