import { mapGetters } from 'vuex'

export default {
  data () {
    return {
      settings: null
    }
  },
  computed: {
    ...mapGetters('SettingsModule', [
      'getSettings'
    ]),
  },
  methods: {
    getGlobalSetting (key) {
      if (!this.getSettings.length === 0) return null
      const found = this.getSettings.find(setting => setting.key === key)
      if (found) return `${found.value}`
      return null
    },
  }
}
