import { cloneDeep } from 'lodash'

export default {
  methods: {
    setInventoryLocation (initialValue = null) {
      if (!initialValue) return
      let location = {}
      if (initialValue.hasOwnProperty('id')) {
        location = {
          id: initialValue.id,
          name: initialValue.name
        }
      }

      return {
        selectedWarehouses: initialValue?.selectedWarehouses ?? [],
        inventoryModificationRules: {
          maxRuleType: initialValue?.inventoryModificationRules?.maxRuleType ?? 'None',
          maxRuleTypeValue: initialValue?.inventoryModificationRules?.maxRuleTypeValue ?? null,
          minRuleType: initialValue?.inventoryModificationRules?.minRuleType ?? 'None',
          minRuleTypeValue: initialValue?.inventoryModificationRules?.minRuleTypeValue ?? null,
          substractBufferStock: initialValue?.inventoryModificationRules?.substractBufferStock ?? '0'
        },
        fulfillmentLatency: initialValue?.fulfillmentLatency ?? '0',
        masterOfStock: initialValue?.masterOfStock ?? 'Neither',
        ...location
      }
    },
    getLocations () {
      if (this.getSelectedItem?.sales_channel_settings?.inventory?.locations) {
        return this.getSelectedItem
          .sales_channel_settings
          .inventory
          .locations
          .map(location => this.setInventoryLocation(location))
      }

      return [this.setInventoryLocation()]
    },
    salesChannelHasLocations () {
      return this.getSelectedItem?.sales_channel_settings?.inventory?.locations !== undefined &&
          this.getSelectedItem?.sales_channel_settings?.inventory?.locations.length > 0
    },
    initializeInventoryValueUsing (item) {
      if (item === null || item === undefined) {
        return
      }

      const initialValue = cloneDeep(item)

      // Default to sales channel inventory rules
      if (initialValue.inventory_rules === undefined || initialValue.inventory_rules === null) {
        initialValue.inventory_rules = item.sales_channel_settings.inventory
      }

      // Set inventory location rules
      if (this.salesChannelHasLocations()) {
        if (!initialValue.inventory_rules.locations) {
          initialValue.inventory_rules.locations = item.sales_channel_settings.inventory.locations
        }
        initialValue.locations = initialValue.inventory_rules.locations
      }

      this.SET_INITIAL_VALUE(initialValue)
      this.SET_EDITING_VALUE(cloneDeep(initialValue))
      this.SET_SELECTED_PRODUCT_LISTING(cloneDeep(initialValue))
    }
  }
}
