export default {
  methods: {
    openWarehouse (warehouse) {
      if (warehouse.supplier && warehouse.supplier.id) {
        this.openSupplierWarehouse({ supplierId: warehouse.supplier.id })
      } else {
        this.openUserWarehouse(warehouse.id)
      }
    },
    async openUserWarehouse (warehouseId) {
      this.$drawer.$emit('open', { name: 'WarehouseDrawer', id: warehouseId, mode: 'WarehouseDashboardDetails', hideNavigator: true })
    },
    async openSupplierWarehouse ({ supplierId }) {
      this.$drawer.$emit('open', { name: 'SupplierDrawer', id: supplierId, mode: 'DashboardInventory', hideNavigator: true })
    }
  }
}
