import { fetchTransactions } from '@/services/AccountingService'

export default {
  data () {
    return {
      transactions: [],
      transactionsLoading: false,
    }
  },
  computed: {
    getTransactions () {
      return this.transactions
    },
    loadingTransaction () {
      return this.transactionsLoading
    },
  },
  methods: {
    async fetchTransactions (reference, link = null) {
      try {
        this.transactionsLoading = true
        const filters = {
          filterSet: []
        }
        if (link) {
          filters.filterSet.push({
            column: 'link_type',
            operator: '=',
            value: link.link_type,
          })
          filters.filterSet.push({
            column: 'link_id',
            operator: '=',
            value: link.link_id,
          })
        } else {
          filters.filterSet.push({
            column: 'reference',
            operator: '=',
            value: reference,
          })
          filters.conjunction = 'and'
        }

        const sendObj = {
          limit: -1,
          filters: JSON.stringify(filters),
        }
        const {data} = await fetchTransactions(sendObj)

        if (data) this.transactions = data
      } finally {
        this.transactionsLoading = false
      }
    },
  },
}
