import { openDrawerByModelPath } from '@/support/drawerHelper'

export default {
  computed: {
    getSelectedItemIndex () {
      return this.getItemsList.findIndex(({ id }) => id === this.getSelectedItem?.id)
    }
  },
  methods: {
    openDrawerByModelPath (path, id) {
      openDrawerByModelPath(this, path, id)
    },
    async fetchNewItem (instanceId, id) {
      try {
        return await this.fetchNewItemForDrawer(instanceId, id)
      } catch (e) {
        return Promise.reject(e)
      }
    },
  }
}
