import moment from 'moment-timezone'
import { mapGetters } from 'vuex'

export default {
  methods: {
    convertDateToUTC (date) {
      return moment.tz(moment(date).format('YYYY-MM-DD HH:mm:ss'), this.getTimezoneValue).utc()
    },
    convertDatesToUTC (startDate, endDate) {
      const utcStartDate = moment.tz(moment(startDate).format('YYYY-MM-DD HH:mm:ss'), this.getTimezoneValue).startOf('day').utc()
      const utcEndDate = moment.tz(moment(endDate).format('YYYY-MM-DD HH:mm:ss'), this.getTimezoneValue).endOf('day').utc()

      return { utcStartDate, utcEndDate }
    },
    convertStartDateToUTC (date) {
      return moment.tz(moment(date).format('YYYY-MM-DD HH:mm:ss'), this.getTimezoneValue).startOf('day').utc()
    },
    convertEndDateToUTC (date) {
      return moment.tz(moment(date).format('YYYY-MM-DD HH:mm:ss'), this.getTimezoneValue).endOf('day').utc()
    },
    requestDateTimeFormat (date) {
      return date.format('YYYY-MM-DD HH:mm:ss')
    },
    getUserTimezoneCode () {
      return moment.tz(this.getTimezoneValue).format('z')
    }
  },
  computed: {
    ...mapGetters('SettingsModule', ['getTimezoneValue', 'getInventoryStartDate'])
  }
}
