import { mapGetters } from 'vuex'
import { dateRequestFormat } from '@/support/helpers'
import { openProductDrawerBySku } from '@/support/drawerHelper'

export default {
  props: {
    isFetch: {
      type: Boolean,
      default: false
    }
  },
  data () {
    return {
      products: [],
      loading: false,
      erroredImages: {}
    }
  },
  watch: {
    isFetch: {
      handler (value) {
        if (value) this.fetchProducts()
      },
      immediate: true,
      deep: true
    }
  },
  computed: {
    ...mapGetters('DashboardModule', [
      'getStartDate',
      'getEndDate'
    ]),
    getFormattedStartDate () {
      return dateRequestFormat(this.getStartDate)
    },
    getFormattedEndDate () {
      return dateRequestFormat(this.getEndDate)
    },
  },
  methods: {
    async openProduct (sku) {
      openProductDrawerBySku(this, sku)
    }
  }
}
