export default {
  computed: {
    todayDateLabel () {
      return this.formattedDate(this.moment())
    },
    yesterdayDateLabel () {
      return this.formattedDate(this.moment().subtract(1, 'days'))
    },
    lastWeekDateLabel () {
      return `${this.formattedDate(this.moment().subtract(1, 'weeks'))} - ${this.formattedDate(this.moment())}`
    },
    isCustomRangeLoading () {
      return this.customRangeLoading || this.loading
    }
  },
  methods: {
    formattedDate (date) {
      if (!date) return
      return date.format(this.getDateFormatValue)
    }
  }
}
