import axios from 'axios'
import { userCredentials, redirectToLogin } from '../services/AuthService'
import { localStorageService, KEYS } from '../support/localStorage'

require('dotenv').config()

const getBaseURL = () => {
  const endpointKey = KEYS.SKU_ENDPOINT
  let url = localStorageService.get(endpointKey)
  if (!url) {
    url = window.location.origin
    localStorageService.set(endpointKey, url)
  }
  return url
}

export const baseURL = getBaseURL()

// Setup Axios Config
const axiosConfig = axios.create({
  baseURL: `${baseURL}/api`,
  timeout: 300000
})

const axiosClean = axios.create({
  baseURL: `${baseURL}/api`,
  timeout: 300000
})

const axiosWeb = axios.create({
  baseURL: baseURL,
  timeout: 300000
})

const addToken = async (config) => {
  const token = userCredentials()
  if (token) {
    config.headers['Authorization'] = `Bearer ${token}`
  }
}

axiosClean.addToken = (config) => addToken(config)

// Request Interceptor
axiosConfig.interceptors.request.use(
  async (config) => {

    if (axiosConfig.omitToken) {
      axiosConfig.omitToken = false
    } else {
      await addToken(config)
    }

    return config
  },

  (error) => {
    return Promise.reject(error)
  }
)

// Response Interceptor
axiosConfig.interceptors.response.use(
  response => response,
  async (error) => {

    if (axiosConfig.noInterceptResponse) {
      axiosConfig.noInterceptResponse = false
      return Promise.reject(error)
    }

    if (error.response && error.response.status === 401) {
      redirectToLogin()
    } else {
      return Promise.reject(error)
    }
  }
)

export default axiosConfig
export { axiosClean, axiosWeb }
