import exactMath from 'exact-math'
import { uniqBy } from 'lodash'
import formatDigit from '@/support/formatDigit'

export default {
  computed: {
    orderSubtotal () {
      if (this.isViewDrawerMode) return this.getSelectedItem?.subtotal || 0
    },
    productSubtotalBeforeDiscount () {
      const allTotalsArray = this.subtotalProductItems.map(i => this.rowPrice(i))
      if (!allTotalsArray.length) return 0
      const sumOfAll = allTotalsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -2)
    },
    productSubtotal () {
      const allTotalsArray = this.subtotalProductItems.map(i => this.rowPriceAfterDiscountAmount(i))
      if (!allTotalsArray.length) return 0
      const sumOfAll = allTotalsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -2)
    },
    productsDiscount () {
      const allDiscountsArray = this.subtotalProductItems.map(i => this.rowDiscount(i))
      if (!allDiscountsArray.length) return 0
      const sumOfAll = allDiscountsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -4)
    },
    orderDiscount () {
      const allDiscountsArray = this.products.map(i => this.rowDiscount(i))
      if (!allDiscountsArray.length) return 0
      const sumOfAll = allDiscountsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -4)
    },
    orderSalesTax () {
      if (!this.getSelectedTaxes || this.getSelectedTaxes.length === 0) return 0
      const allTaxesArray = this.getSelectedTaxes.map(tax => tax.amount || 0)
      const sumOfAll = allTaxesArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -2)
    },
    orderTotal () {
      const allTotalsArray = this.products.map(i => this.rowPricePlusTax(i))
      if (!allTotalsArray.length) return 0
      const sumOfAll = allTotalsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -2)
    },
    subtotalProductItems () {
      return this.products.filter(i => i.sku && i.sku.id)
    },
    subtotalNonProductItems () {
      const nonProducts = this.products.filter(i => !(i.sku && i.sku.id))
      return uniqBy(nonProducts, 'name')
    },
    nonProductSubtotal () {
      return this.subtotalNonProductItems.reduce((acc, item) => acc + this.nonProductRowSubtotal(item), 0)
    },
    totalTax () {
      if(this.getSelectedItem.tax_rate_id && this.getSelectedItem.tax_cost) return this.getSelectedItem.tax_cost
      return this.products.reduce((acc, item) => acc + (+item.tax_allocation), 0)
    },
    invoiceSummaryOrderTotal(){
      const allTotalsArray = this.products.map(i => this.rowPriceAfterDiscount(i))
      if (!allTotalsArray.length) return 0
      const sumOfAll = allTotalsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(exactMath.add(sumOfAll,this.totalTax), -2)
    }
  },
  methods: {
    formatDigit,
    totalUnits (items) {
      const quantities = items.filter(i => {
        return !!(i.sku && i.sku.id)
      }).map(i => i.quantity || 0)

      if (!quantities.length) return 0

      return quantities.reduce((acc, value) => exactMath.add(acc, value))
    },
    rowPrice (row) {
      const x = Number(row?.price || 0)
      const y = Number(row?.quantity || 0)

      return exactMath.mul(x, y)
    },
    rowPriceAfterDiscountAmount (row) {
      const x = this.rowPrice(row)
      const y = this.rowDiscount(row)
      return exactMath.sub(x, y)
    },
    rowDiscountAmount (row) {
      return row?.discount_amount || 0
    },
    rowDiscount (row) {
      const x = this.rowPrice(row)
      if (row.discount_rate !== undefined && row.discount_rate !== null) {
        return exactMath.mul(x, row.discount_rate)
      }
      if (row.discount_amount !== undefined && row.discount_amount !== null) {
        return row.discount_amount * row.quantity
      }
      return 0
    },
    rowPriceAfterDiscount (row) {
      const x = this.rowPrice(row)
      const y = this.rowDiscount(row)

      return exactMath.sub(x, y)
    },
    nonProductRowSubtotal (row) {
      // if they share name, we want to show one subtotal for all such items
      const sumOfAllPricesAfterDiscount = this.products.filter(i => !(i.sku && i.sku.id) && i.name === row.name)
        .map(row => this.rowPriceAfterDiscount(row))
        .reduce((acc, value) => exactMath.add(acc, value))

      return exactMath.round(sumOfAllPricesAfterDiscount, -2)
    },
    rowTax (row) {
      if (this.getSelectedIsTaxIncluded || !this.getSelectedTaxes || this.getSelectedTaxes.length === 0) return 0
      const x = this.rowPriceAfterDiscount(row)
      const y = this.getSelectedOrderTaxRate?.tax_rate_id
        ? Number(this.getSelectedOrderTaxRate.tax_rate || 0)
        : Number(row.tax_rate || 0)
      const xTimesY = exactMath.mul(x, y)

      return exactMath.div(xTimesY, 100)
    },
    rowPricePlusTax (row) {
      const x = this.rowPriceAfterDiscount(row)
      const y = this.rowTax(row)

      return exactMath.add(x, y)
    }
  }
}
