import exactMath from 'exact-math'

export default {
  methods: {
    // row calculations
    rowPrice (row) {
      const x = Number(row?.price || 0)
      const y = Number(row?.quantity || 0)
      return exactMath.mul(x, y)
    },
    rowDiscount (row) {
      const x = this.rowPrice(row)
      const y = Number(row.discount || 0)
      const xTimesY = exactMath.mul(x, y)
      return exactMath.div(xTimesY, 100)
    },
    rowPriceAfterDiscount (row) {
      const x = this.rowPrice(row)
      const y = this.rowDiscount(row)
      return exactMath.sub(x, y)
    }
  },
  computed: {
    productSubtotalBeforeDiscount () {
      const allTotalsArray = this.subtotalProductItems.map(i => this.rowPrice(i))
      if (!allTotalsArray.length) return 0
      const sumOfAll = allTotalsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -2)
    },
    productSubtotalAfterDiscount () {
      if (this.isViewDrawerMode || this.isEditDrawerMode) return this.getEditedOrderSubtotal

      const allTotalsArray = this.subtotalProductItems.map(i => this.rowPriceAfterDiscount(i))
      if (!allTotalsArray.length) return 0
      const sumOfAll = allTotalsArray.reduce((acc, value) => exactMath.add(acc, value))
      return exactMath.round(sumOfAll, -2)
    },
    calculateUpdatedTax () {
      return this.getSelectedTaxes.reduce((acc, tax) => {
        acc = exactMath.add(acc, parseFloat(tax.amount))
        return acc
      }, 0)
    },
    nonProductsTotal () {
      return this.nonProducts.reduce((acc, item) => {
        acc = exactMath.round(exactMath.add(acc, this.rowPriceAfterDiscount(item)), -2)
        return acc
      }, 0)
    },
    subTotalBeforeTaxes () {
      return this.productSubtotalAfterDiscount + this.nonProductsTotal
    },
    subTotalAfterTaxes () {
      let totalOfItems = this.productSubtotalAfterDiscount + this.nonProductsTotal
      return totalOfItems + this.calculateUpdatedTax || 0
    }
  }
}
