import {
  isNonProductType,
  isProductType,
  isUnmappedType,
  isExternallyFulfilledType,
} from '@/support/salesOrdersProductListHelpers'

export default {
  computed: {
    isEditMode () {
      return this.getDrawerMode === 'edit'
    },
    isViewMode () {
      return this.getDrawerMode === 'view'
    },
    isCreateMode () {
      return this.getDrawerMode === 'create'
    },
    isProductableType () {
      return this.isProduct || this.isUnmapped || this.isExternallyFulfilled
    },
    isProduct () {
      return isProductType(this.type)
    },
    isExternallyFulfilled () {
      return isExternallyFulfilledType(this.type)
    },
    isUnmapped () {
      return isUnmappedType(this.type)
    },
    isNonProduct () {
      return isNonProductType(this.type)
    },
  }
}
