export default {
  methods: {
    showSimpleFulfillButton (warehouse) {
      return !this.isWarehouseFulfilled && !warehouse.supplier_name
    },
    showDropshipFulfillButton (warehouse) {
      return !this.isWarehouseFulfilled && warehouse.supplier_name && this.isDropshipRequested
    },
    isWarehouseFulfilled (warehouseProducts) {
      let isFulfilled = true
      for (let i = 0; i <= warehouseProducts.length; i++) {
        let product = warehouseProducts[i]
        if (product && !product.is_fulfilled) {
          isFulfilled = false
          break
        }
      }
      return isFulfilled
    },
    isWarehouseNotFulfillable (warehouseProducts) {
      // if all items are not fulfillable then warehouse is not fulfillable
      let isNotFulfillableCount = 0
      for (let i = 0; i <= warehouseProducts.length; i++) {
        let product = warehouseProducts[i]
        if (product) {
          if (product.backordered_quantity) {
            if (Number(product.backordered_quantity.total_released) + Number(product.unfulfilled_quantity) - Number(product.backordered_quantity.total_backordered) <= 0) {
              isNotFulfillableCount++
            }
          } else {
            if (Number(product.unfulfilled_quantity) <= 0) {
              isNotFulfillableCount++
            }
          }
        }
        
      }
      return isNotFulfillableCount === warehouseProducts.length
    },
  },
}
