import exactMath from 'exact-math'

export default {
  methods: {
    calculateFulfilledQuantity (fulfillments, quantityProp = 'quantity') {
      return fulfillments.reduce((acc, row) => {
        return acc = exactMath.add(acc, row[quantityProp])
      },0)
    },
    calculateReservedQuantity (row, fulfilledQty) {
      if (!row?.item_reserved_quantity || row.item_reserved_quantity == 0) return 0

      return exactMath.sub(Number(row.item_reserved_quantity), fulfilledQty)
    },
    calculateFulfillmentQuantity (warehouse, row, reservedQty, fulfillmentToCreateQty = 0) {
      if (warehouse?.type === 'supplier') {
        return exactMath.sub(Number(row.item_quantity), Number(row.item_dropshipped_quantity || 0), fulfillmentToCreateQty)
      }
      if (reservedQty === 0) return 0
      const backorderedQty = row?.backordered_quantity ?
      exactMath.sub(Number(row.backordered_quantity.total_backordered || 0), Number(row.backordered_quantity.total_released || 0)) :
      0

      return exactMath.sub(reservedQty, backorderedQty, fulfillmentToCreateQty)
    },
    getByRowFulfillmentsToCreateLine (row) {
      if (!row?.sales_order_line_id) return null
      return this.getFulfillmentsToCreateLines.find(line => line.sales_order_line_id === row.sales_order_line_id )
    },
    getByRowFulfillmentToCreateQty (row) {
      const line = this.getByRowFulfillmentsToCreateLine(row)
      return line?.quantity ? line.quantity : 0
    },
    getFulfillableQuantity (item) {
      const fulfilledQty = this.calculateFulfilledQuantity(item?.warehouse.fulfillments_data || [])
      const reservedQty = this.calculateReservedQuantity(item, fulfilledQty)

      return this.calculateFulfillmentQuantity(
        item.warehouse,
        item,
        reservedQty,
        this.getByRowFulfillmentToCreateQty(item)
      )
    },
  },
}
