export default {
  methods: {
    checkValidFulfillmentDate (date, startDate) {
      const prepareStartDate = this.prepareStartDate(startDate)
      const prepareDate = this.prepareDate(date)
      if (!prepareStartDate || !prepareDate) return false

      return this.moment(prepareDate).isAfter(prepareStartDate) || this.moment(prepareDate).isSame(prepareStartDate)
    },
    prepareStartDate (startDate) {
      if (startDate.search(/[\d]{4}-[\d]{2}-[\d]{2}/) === -1) return null
      if (this.isValidDateString(startDate)) return startDate
      if (startDate.search(/UTC[\d]{2}:[\d]{}/)) {
        let [date,time = '00:00:00'] = startDate.split('UTC')
        time = time.search(/[Z,z]/ !== -1) ? time : `${time}Z`
        return `${date}T${time}Z`
      }
      const [date] = startDate.match(/[\d]{4}-[\d]{2}-[\d]{2}/)
      return date ? `${date}T00:00:00Z` : null
    },
    prepareDate(value) {
      if (value.search(/[\d]{4}-[\d]{2}-[\d]{2}/) === -1) return null;
      if (this.isValidDateString(value)) return value;
      if (value.search(/T[\d]{2}:[\d]{2}:[\d]{2}/) !== -1) {
        const [d, t] = value.split('T');
        const time = this.parceTimeString(t);
        return `${d}T${time}`;
      }
      const [date] = value.match(/[\d]{4}-[\d]{2}-[\d]{2}/);
      return date ? `${date}T00:00:00Z` : null;
    },
    parceTimeString(timeString) {
      if (!timeString) return '00:00:00Z';
      const time = timeString.substring(0, 8);
      return `${time}Z`;
    },
    isValidDateString(string) {
      return string.search(/[\d]{4}-[\d]{2}-[\d]{2}T[\d]{2}:[\d]{2}:[\d]{2}Z/) !== -1;
    },
  },
}
