import showErrors from '@/support/showErrors'
import { mapMutations } from 'vuex'
import { getUpdatedInstancePayload } from '@/support/integrations/woocommerceHelpers'
import {
  updateWoocommerceIntegrationInstance
} from '@/services/woocommerce/WoocommerceIntegrationService'

export default {
  data () {
    return {
      saveLoading: false,
      editedValues: null,
      initialValues: null
    }
  },
  methods: {
    ...mapMutations('IntegrationsModule', ['SET_SELECTED_INSTANCE']),
    async updateHandler (editedValues) {
      try {
        this.saveLoading = true
        const setData = getUpdatedInstancePayload(
          editedValues,
          this.prepareDate(this.editedValues.start_date)
        )

        const { data } = await updateWoocommerceIntegrationInstance(this.$route.params.instanceId, setData)
        this.initValues(data)
        this.SET_SELECTED_INSTANCE(data)

        this.$notification.$emit('success')
      } catch (e) {
        showErrors.call(this, e)
        console.log(e)
      } finally {
        this.saveLoading = false
      }
    },
    revertChanges () {
      this.editedValues = JSON.parse(JSON.stringify(this.initialValues))
    }
  }
}
