import { mapGetters } from 'vuex'
import { fromUserTimezoneToUtc } from '@/support/timeHelper'

export default {
  computed: {
    ...mapGetters('IntegrationsModule', ['getIntegrationForInitialSetup']),
    isSalesChannel () {
      return this.getIntegrationForInitialSetup?.integration_type === 'sales_channel'
    },
  },
  methods: {
    async save () {
      // we create an instance but then redirect the user to integration site to provide additional details
      this.$nextTick(() => {
        this.saving()
      })
    },
    prepareDate (value) {
      return fromUserTimezoneToUtc(value)
    },
  },
}
