import { mapGetters } from 'vuex'
import { toUserTimezone } from '@/support/timeHelper'

export default {
  computed: {
    ...mapGetters('SettingsModule', [
      'getSettings',
      'getDateTimeFormatValue',
      'getInventoryStartDate'
    ]),
    getClosedStartDate () {
      return toUserTimezone(this.editedValues?.download?.closed_start_date)
    },
    getOpenStartDate () {
      return toUserTimezone(this.editedValues?.download?.open_start_date)
    },
    inventoryStartDate () {
      return this.getInventoryStartDate ?? 'unknown'
    },
    isSetInventoryStartDate () {
      return this.inventoryStartDate !== 'unknown'
    }
  },
  methods: {
    disabledDate (date) {
      if (this.inventoryStartDate && this.isSetInventoryStartDate) {
        return this.moment(date).isBefore(this.inventoryStartDate)
      }
      return false
    },
    editDateValue (key, value) {
      this.editValue({ key: 'download', value: { ...this.editedValues.download, [key]: value } })
    },
    editValue ({ key, value, isStatus }) {
      this.$emit('change', { key, value, isStatus })
    }
  }
}
