import {
  unmapListings,
  downloadListings,
  deleteListingById,
  deleteListings,
  isDeletableListing,
} from '@/services/IntegrationsService'

export default {
  data () {
    return {
      detailsRow: null,
      showDetailsModal: false,
      showMapProductModal: false,
      selectedRowToMap: null,
    }
  },
  methods: {
    deleteRow (usefulProps) {
      this.openDeleteModal({ row: usefulProps.row })
      usefulProps.closeMenu()
    },
    deleteRows (usefulProps) {
      this.openDeleteModal({ row: usefulProps.row, rows: this.getSelectedRowsObjects, selectedAllRows: this.getSelectedAllRows })
      usefulProps.closeMenu()
    },
    deleteItemByIdMixinMethod (itemId) {
      return deleteListingById(this.$route.params.instanceId, itemId)
    },
    deleteItemsMixinMethod (data) {
      return deleteListings(this.$route.params.instanceId, data)
    },
    isDeletableMixinMethod (ids) {
      return isDeletableListing(this.$route.params.instanceId, ids)
    },
    showDetails (row) {
      this.detailsRow = row
      this.showDetailsModal = true
    },
    openMapModal (row) {
      this.selectedRowToMap = row
      this.showMapProductModal = true
    },
    async downloadListings () {
      try {
        this.listingsDownloading = true
        await this.downloadListings(this.$route.params.instanceId)
        this.$notification.$emit('success', { html: 'Listings download added to the Queue, it will be processed shortly.' })
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.listingsDownloading = false
      }
    },
    openImportDrawer () {
      this.$drawer.$emit('open', { name: 'ImportDrawer', mode: this.mappingsImportMode })
    }
  },
}
