import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      finalizing: false,
    }
  },
  methods: {
    async authInstance (id) {
      try {
        this.finalizing = true
        const {data} = await this.handleAuthInstance(id)
        if (data) window.location.href = data
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.finalizing = false
      }
    },
  }
}
