import { authAmazonInstance } from '@/services/AmazonIntegrationService'
import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      finalizing: false,
    }
  },
  methods: {
    async authAmazonInstance (id) {
      try {
        this.finalizing = true
        const {data} = await authAmazonInstance(id)
        if (data) window.location.href = data
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.finalizing = false
      }
    },
  }
}
