import { mapGetters, mapMutations } from 'vuex'
import { getIntegrationInstanceById } from '@/services/IntegrationsService'
import showErrors from '@/support/showErrors'

export default {
  computed: {
    ...mapGetters('IntegrationsModule', ['getIntegrationsData', 'getSelectedIntegration', 'getSelectedInstance', 'getSelectedSalesChannel'])
  },
  created () {
    this.fetchIntegrationInstance()
  },
  watch: {
    getSelectedInstance: {
      handler (newVal) {
        if (!newVal || !newVal.connection_settings) return

        if (newVal?.connection_settings.hasOwnProperty('invalid') && newVal.connection_settings.invalid) {
          this.$notification.$emit('danger', { permanent: 1, html: 'Invalid credentials!', closeButton: true })
        }
      },
      immediate: true,
      deep: true
    }
  },
  methods: {
    ...mapMutations('IntegrationsModule', ['UPDATE_INTEGRATION_DATA', 'SET_AUTOMATED_WAREHOUSES']),
    async fetchIntegrationInstance () {
      const instanceId = Number(this.$route.params.instanceId)
      if (!instanceId) return

      try {
        const response = await this.fetchIntegrationInstanceById(instanceId)
        // if (!response) return
        this.UPDATE_INTEGRATION_DATA(response.data)
        this.SET_AUTOMATED_WAREHOUSES(response.automated_warehouses)
      } catch (e) {
        console.log('errors', e)
        showErrors.call(this, e)
      }
    },
    // Having a mixing method to fetch the instance allows
    // for simple overrides in different integration instances
    async fetchIntegrationInstanceById (instanceId) {
      return getIntegrationInstanceById(instanceId)
    }
  }
}
