export function assignPath (obj, keyPath, value) {
  let lastKeyIndex = keyPath.length - 1
  for (var i = 0; i < lastKeyIndex; ++i) {
    let key = keyPath[i]
    if (!(key in obj)) {
      obj[key] = {}
    }
    obj = obj[key]
  }
  obj[keyPath[lastKeyIndex]] = value
}

export function obtainPath (obj, keyPath, defaultValue) {
  for (var i = 0; i <= keyPath.length - 1; ++i) {
    let key = keyPath[i]
    if (!(key in obj)) {
      return defaultValue
    }
    obj = obj[key]
  }
  return obj
}

export function replaceKey (obj, oldKey, newKey) {
  let newObj = {}
  for (let [key, val] of Object.entries(obj)) {
    if (key === oldKey) {
      newObj[newKey] = val
    } else {
      newObj[key] = val
    }
  }
  return newObj
}

export function deepClone (obj) {
  return JSON.parse(JSON.stringify(obj))
}
