import { getEnumsList, getEnumDictionary } from '@/support/enumHelpers'
import { CONTEXT_NAMES } from '@/assets/constants'

const statuses = [
  { data_name: 'completed', friendly_name: 'Completed', },
  { data_name: 'cancelled', friendly_name: 'Cancelled', },
  { data_name: 'processing', friendly_name: 'Processing', },
  { data_name: 'refunded', friendly_name: 'Refunded', },
  { data_name: 'on-hold', friendly_name: 'On Hold', },
  { data_name: 'any', friendly_name: 'Any', },
  { data_name: 'failed', friendly_name: 'Failed', },
  { data_name: 'trash', friendly_name: 'Trash', },
  { data_name: 'pending', friendly_name: 'Pending', },
]

const ENUMS = [
  ...getEnumDictionary(statuses, 'status'),
]

export default (() => { return getEnumsList(ENUMS, CONTEXT_NAMES.WOOCOMMERCE.ORDER)})()
