import { getEnumsList, getEnumDictionary } from '@/support/enumHelpers'
import { CONTEXT_NAMES } from '@/assets/constants'

const orderStatuses = [
  { data_name: 'draft', friendly_name: 'Draft', },
  { data_name: 'reserved', friendly_name: 'Reserved', },
  { data_name: 'open', friendly_name: 'Open', },
  { data_name: 'closed', friendly_name: 'Closed', },
]

const paymentStatuses = [
  { data_name: 'unpaid', friendly_name: 'Unpaid', },
  { data_name: 'partially_paid', friendly_name: 'Partially Paid', },
  { data_name: 'paid', friendly_name: 'Paid', },
  { data_name: 'refunded', friendly_name: 'Refunded', },
  { data_name: 'partially_refunded', friendly_name: 'Partially Refunded', },
]

const fulfillmentStatuses = [
  { data_name: 'unfulfilled', friendly_name: 'Unfulfilled', },
  { data_name: 'partially_fulfilled', friendly_name: 'Partially Fulfilled', },
  { data_name: 'fulfilled', friendly_name: 'Fulfilled', },
  { data_name: 'over_fulfilled', friendly_name: 'Over Fulfilled', },
  { data_name: 'awaiting_tracking', friendly_name: 'Awaiting Tracking', },
  { data_name: 'out_of_sync', friendly_name: 'Out of Sync', },
]

const fulfillmentChannels = [
  { data_name: 'AFN', friendly_name: 'AFN', },
  { data_name: 'MFN', friendly_name: 'MFN', },
]

const ENUMS = [
  ...getEnumDictionary(orderStatuses, 'order_status'),
  ...getEnumDictionary(paymentStatuses, 'payment_status'),
  ...getEnumDictionary(fulfillmentStatuses, 'fulfillment_status'),
  ...getEnumDictionary(fulfillmentChannels, 'fulfillment_channel'),
]

export default (() => { return getEnumsList(ENUMS, CONTEXT_NAMES.SALES_ORDER) })()
