import { getEnumsList } from '@/support/enumHelpers'
import { CONTEXT_NAMES } from '@/assets/constants'

const {
  PRORATION_STRATEGY,
  CLASSIFICATION,
  LINES,
} = CONTEXT_NAMES.FINANCIALS

const ENUMS = [
  {
    variable_name: PRORATION_STRATEGY,
    data_name: 'revenue_based',
    friendly_name: 'Revenue Based',
  },
  {
    variable_name: PRORATION_STRATEGY,
    data_name: 'cost_based',
    friendly_name: 'Cost Based',
  },
  {
    variable_name: PRORATION_STRATEGY,
    data_name: 'weight_based',
    friendly_name: 'Weight Based',
  },
  {
    variable_name: PRORATION_STRATEGY,
    data_name: 'volume_based',
    friendly_name: 'Volume Based',
  },
  {
    variable_name: PRORATION_STRATEGY,
    data_name: 'quantity_based',
    friendly_name: 'Quantity Based',
  },
  {
    variable_name: PRORATION_STRATEGY,
    data_name: 'specific_line',
    friendly_name: 'Specific Line',
  },
  {
    variable_name: CLASSIFICATION,
    data_name: 'revenue',
    friendly_name: 'Revenue',
  },
  {
    variable_name: CLASSIFICATION,
    data_name: 'cost',
    friendly_name: 'Cost',
  },
]

export default (() => { return getEnumsList(ENUMS, LINES)})()
