import store from '@/store/store'

const isAdminUser = store.getters['UsersModule/getIsAdmin']
const getUrl = (path) => `/settings/${path}`

const settings =  {
  ACCOUNTING: [
    {
      name: 'General',
      url: getUrl('accounting-general'),
      label: 'Enable Accounting Transactions'
    },
    {
      name: 'Nominal Codes',
      url: getUrl('nominal-codes'),
      label: 'Codes to map to your Chart of Accounts'
    },
    {
      name: 'Tax Rates',
      url: getUrl('tax-rates'),
      label: 'Tax Rates'
    }
  ],
  DATA_FEED: [
    {
      name: 'Feeds',
      label: 'List of available data feeds',
      url: getUrl('data-feeds')
    }
  ],
  INVENTORY: [
    {
      name: 'Forecasting',
      label: 'Settings for calculating inventory forecasting',
      url: getUrl('forecasting')
    },
    {
      name: 'Warehouses',
      label: 'Warehouse Priorities',
      url: getUrl('warehouses')
    },
    {
      name: 'Warehouse transfers',
      label: 'Default settings for warehouse transfers',
      url: getUrl('warehouse-transfers')
    },
    {
      name: 'Inventory Start Date',
      label: 'Set the date you will start tracking inventory in sku.io',
      url: getUrl('inventory-start-date')
    }
  ],
  GENERAL: [
    {
      name: 'Stores',
      label: 'Stores for your business (in case you operate under multiple identities)',
      url: getUrl('stores')
    },
    {
      name: 'Tags',
      label: 'Manage your tags',
      url: getUrl('tags')
    },
    {
      name: 'Currencies',
      label: 'Set the currencies you will sell in and their conversion rates',
      url: getUrl('currencies')
    },
    /* {
      name: 'CSV Templates',
      label: 'Re-usable templates to use for importing',
      url: getUrl('csv-templates'),
    }, */
    {
      name: 'Shipping Methods',
      label: 'Shipping methods you will be using',
      url: getUrl('shipping-methods')
    },
    {
      name: 'Auto Fulfillments',
      label: 'Auto fulfillment settings',
      url: getUrl('auto-fulfillments')
    },
    {
      name: 'Sales Orders',
      label: 'Default settings for sales orders',
      url: getUrl('sales-orders')
    },
    {
      name: 'Return Reasons',
      label: 'Pre-set reasons for accepting returns',
      url: getUrl('return-reasons')
    },
    {
      name: 'Payment Types',
      label: 'Payment types to accept payments for',
      url: getUrl('payment-types')
    },
    {
      name: 'Email Templates',
      label: 'Templates for system emails that sku.io sends out to customer and suppliers',
      url: getUrl('email-templates')
    },
    {
      name: 'Date & Time',
      label: 'Set the timezone you operate under',
      url: getUrl('date-time')
    },
    {
      name: 'Sales Credits',
      label: 'Default Returns Warehouse',
      url: getUrl('sales-credits')
    },
    {
      name: 'Background Jobs Log',
      label: 'Background Jobs Log',
      url: getUrl('background-jobs-log')
    },
    {
      name: 'Advanced Shipment Notices',
      label: 'Advanced shipment notices settings',
      url: getUrl('advanced-shipment-notices')
    }
  ],
  PRODUCTS: [
    {
      name: 'Attributes',
      label: 'Set the product attributes you will use',
      url: getUrl('attributes')
    },
    {
      name: 'Attribute Groups',
      label: 'Group product attributes',
      url: getUrl('attribute-groups')
    },
    {
      name: 'Brands',
      label: 'A list of brands you sell',
      url: getUrl('brands')
    },
    {
      name: 'Categories',
      label: 'Manage the category trees you use to organize products',
      url: getUrl('categories')
    },
    {
      name: 'Pricing Tiers',
      label: 'Pricing tiers for sales',
      url: getUrl('pricing-tiers')
    },
    {
      name: 'Barcodes',
      label: 'Organize displaying of product barcodes',
      url: getUrl('barcodes')
    },
    {
      name: 'Units of Measurement',
      label: 'Units of Measurement for products',
      url: getUrl('units-of-measurement')
    },
    {
      name: 'Blemished Products',
      label: 'Settings related to blemished products',
      url: getUrl('blemished-products')
    }
  ],
  PURCHASING: [
    /* {
      name: 'Incoterms',
      label: 'Short Description',
      url: getUrl('incoterms'),
    }, */
    {
      name: 'Purchase Orders',
      label: 'Default settings for purchase orders',
      url: getUrl('purchase-orders')
    },
    {
      name: 'Supplier Pricing Tiers',
      label: 'Supplier pricing tiers for purchasing',
      url: getUrl('supplier-pricing-tiers')
    },
    {
      name: 'PO Builder',
      label: 'Default PO builder options',
      url: getUrl('purchase-orders-builder')
    }
  ],
  FINANCIALS: [
    {
      name: 'Financial Types',
      label: 'Settings for financial types',
      url: getUrl('financial-types')
    }
  ],
  REPORTING: [
    {
      name: 'Financial Alerts',
      label: 'Settings for Financial Alerts',
      url: getUrl('financial-alerts')
    }

  ]
}

if (isAdminUser) {
  settings.GENERAL.push({
    name: 'Users',
    label: 'List Of All Users',
    url: getUrl('users')
  });
}


export default settings
