<?php

namespace Database\Seeders\SampleData;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class WarehousesTableSeeder extends Seeder
{
    /**
     * Auto generated seed file
     */
    public function run(): void
    {
        \DB::table('warehouses')->delete();

        \DB::table('warehouses')->insert([
            0 => [
                'id' => 1,
                'name' => 'Los Angeles Warehouse',
                'type' => 'direct',
                'address_id' => 12,
                'supplier_id' => null,
                'integration_instance_id' => null,
                'order_fulfillment' => 'manual',
                'dropship_enabled' => 0,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:03:44',
                'updated_at' => '2023-03-26 02:17:44',
            ],
            1 => [
                'id' => 3,
                'name' => 'Little Threads - Main Warehouse',
                'type' => 'supplier',
                'address_id' => 3,
                'supplier_id' => 2,
                'integration_instance_id' => null,
                'order_fulfillment' => null,
                'dropship_enabled' => 1,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:03:44',
                'updated_at' => '2023-03-26 02:03:44',
            ],
            2 => [
                'id' => 4,
                'name' => 'Cuddlebug Clothing Co. Main Warehouse',
                'type' => 'supplier',
                'address_id' => 5,
                'supplier_id' => 3,
                'integration_instance_id' => null,
                'order_fulfillment' => null,
                'dropship_enabled' => 1,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:04:10',
                'updated_at' => '2023-03-26 02:07:36',
            ],
            3 => [
                'id' => 5,
                'name' => 'Baby Bumble - Main Warehouse',
                'type' => 'supplier',
                'address_id' => 7,
                'supplier_id' => 4,
                'integration_instance_id' => null,
                'order_fulfillment' => null,
                'dropship_enabled' => 1,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:08:19',
                'updated_at' => '2023-03-26 02:10:10',
            ],
            4 => [
                'id' => 6,
                'name' => 'Tiny Threads - Main Warehouse',
                'type' => 'supplier',
                'address_id' => 9,
                'supplier_id' => 5,
                'integration_instance_id' => null,
                'order_fulfillment' => null,
                'dropship_enabled' => 1,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:10:30',
                'updated_at' => '2023-03-26 02:12:31',
            ],
            5 => [
                'id' => 7,
                'name' => 'Precious Poppet Enterprises - Main Warehouse',
                'type' => 'supplier',
                'address_id' => 11,
                'supplier_id' => 6,
                'integration_instance_id' => null,
                'order_fulfillment' => null,
                'dropship_enabled' => 1,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:12:38',
                'updated_at' => '2023-03-26 02:14:18',
            ],
            6 => [
                'id' => 8,
                'name' => 'Charlotte Warehouse',
                'type' => 'direct',
                'address_id' => 13,
                'supplier_id' => null,
                'integration_instance_id' => null,
                'order_fulfillment' => 'manual',
                'dropship_enabled' => 0,
                'direct_returns' => 0,
                'customer_returns' => 0,
                'archived_at' => null,
                'created_at' => '2023-03-26 02:17:58',
                'updated_at' => '2023-03-26 02:17:58',
            ],
        ]);

        Setting::query()->where('key', Setting::KEY_WAREHOUSE_PRIORITY)->update([
            'value' => '"[1,8]"',
        ]);
    }
}
