<?php

namespace Database\Seeders\SampleData;

use App\Helpers;
use App\Models\Setting;
use Illuminate\Database\Seeder;

class SuppliersTableSeeder extends Seeder
{
    /**
     * Auto generated seed file
     */
    public function run(): void
    {
        \DB::table('suppliers')->delete();

        \DB::table('suppliers')->insert([
            0 => [
                'id' => 2,
                'name' => 'Little Threads',
                'company_name' => 'Little Threads Inc.',
                'primary_contact_name' => 'Jane Smith',
                'email' => 'jane@littlethreads.com',
                'purchase_order_email' => 'purchase@littlethreads.com',
                'website' => 'www.littlethreads.com',
                'leadtime' => 3,
                'minimum_order_quantity' => null,
                'minimum_purchase_order' => '56.0000',
                'address_id' => 2,
                'purchase_order_format' => null,
                'default_pricing_tier_id' => null,
                'default_warehouse_id' => 3,
                'default_shipping_method_id' => null,
                'default_store_id' => null,
                'auto_fulfill_dropship' => 0,
                'auto_submit_dropship_po' => 0,
                'po_processing_method' => 'individually',
                'po_batch_schedule' => null,
                'auto_generate_backorder_po' => 0,
                'auto_submit_backorder_po' => 0,
                'auto_receive_backorder_po' => 0,
                'backorder_po_schedule' => null,
                'default_stock_level' => 'in_stock',
                'default_tax_rate_id' => null,
                'timezone' => Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE),
                'created_at' => '2023-03-26 02:03:44',
                'updated_at' => '2023-03-26 02:03:44',
                'archived_at' => null,
            ],
            1 => [
                'id' => 3,
                'name' => 'Cuddlebug Clothing Co.',
                'company_name' => 'Cuddlebug Clothing Company',
                'primary_contact_name' => 'John Doe',
                'email' => 'john@cuddlebugclothing.com',
                'purchase_order_email' => 'purchase@cuddlebugclothing.com',
                'website' => 'www.cuddlebugclothing.com',
                'leadtime' => null,
                'minimum_order_quantity' => null,
                'minimum_purchase_order' => null,
                'address_id' => 4,
                'purchase_order_format' => null,
                'default_pricing_tier_id' => null,
                'default_warehouse_id' => 4,
                'default_shipping_method_id' => null,
                'default_store_id' => null,
                'auto_fulfill_dropship' => 0,
                'auto_submit_dropship_po' => 0,
                'po_processing_method' => 'individually',
                'po_batch_schedule' => null,
                'auto_generate_backorder_po' => 0,
                'auto_submit_backorder_po' => 0,
                'auto_receive_backorder_po' => 0,
                'backorder_po_schedule' => null,
                'default_stock_level' => 'in_stock',
                'default_tax_rate_id' => null,
                'timezone' => Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE),
                'created_at' => '2023-03-26 02:04:10',
                'updated_at' => '2023-03-26 02:07:45',
                'archived_at' => null,
            ],
            2 => [
                'id' => 4,
                'name' => 'Baby Bumble',
                'company_name' => 'Baby Bumble LLC',
                'primary_contact_name' => 'Samantha Lee',
                'email' => 'sam@babybumble.com',
                'purchase_order_email' => 'purchase@babybumble.com',
                'website' => 'www.babybumble.com',
                'leadtime' => null,
                'minimum_order_quantity' => null,
                'minimum_purchase_order' => null,
                'address_id' => 6,
                'purchase_order_format' => null,
                'default_pricing_tier_id' => null,
                'default_warehouse_id' => 5,
                'default_shipping_method_id' => null,
                'default_store_id' => null,
                'auto_fulfill_dropship' => 1,
                'auto_submit_dropship_po' => 1,
                'po_processing_method' => 'individually',
                'po_batch_schedule' => '[{"time":"20:00","days":["monday","tuesday","wednesday","thursday","friday"]},{"time":"23:00","days":["monday","tuesday","wednesday","thursday","friday"]}]',
                'auto_generate_backorder_po' => 1,
                'auto_submit_backorder_po' => 0,
                'auto_receive_backorder_po' => 0,
                'backorder_po_schedule' => '[{"time":"16:00","days":["monday","tuesday","wednesday","thursday","friday"],{"time":"20:00","days":["monday","tuesday","wednesday","thursday","friday"]},{"time":"23:00","days":["monday","tuesday","wednesday","thursday","friday"]}]',
                'default_stock_level' => 'in_stock',
                'default_tax_rate_id' => null,
                'timezone' => Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE),
                'created_at' => '2023-03-26 02:08:19',
                'updated_at' => '2023-03-26 02:15:31',
                'archived_at' => null,
            ],
            3 => [
                'id' => 5,
                'name' => 'Tiny Threads',
                'company_name' => 'Tiny Threads Co.',
                'primary_contact_name' => 'David Kim',
                'email' => 'david@tinythreadsco.com',
                'purchase_order_email' => 'purchase@tinythreadsco.com',
                'website' => 'www.tinythreadsco.com',
                'leadtime' => null,
                'minimum_order_quantity' => null,
                'minimum_purchase_order' => null,
                'address_id' => 8,
                'purchase_order_format' => null,
                'default_pricing_tier_id' => null,
                'default_warehouse_id' => 6,
                'default_shipping_method_id' => null,
                'default_store_id' => null,
                'auto_fulfill_dropship' => 0,
                'auto_submit_dropship_po' => 0,
                'po_processing_method' => 'individually',
                'po_batch_schedule' => null,
                'auto_generate_backorder_po' => 0,
                'auto_submit_backorder_po' => 0,
                'auto_receive_backorder_po' => 0,
                'backorder_po_schedule' => null,
                'default_stock_level' => 'in_stock',
                'default_tax_rate_id' => null,
                'timezone' => Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE),
                'created_at' => '2023-03-26 02:10:30',
                'updated_at' => '2023-03-26 02:12:20',
                'archived_at' => null,
            ],
            4 => [
                'id' => 6,
                'name' => 'Precious Poppet Enterprises',
                'company_name' => 'Precious Poppet Enterprises',
                'primary_contact_name' => 'Emily Chen',
                'email' => 'emily@preciouppoppet.com',
                'purchase_order_email' => 'purchase@preciouppoppet.com',
                'website' => 'www.preciouppoppet.com',
                'leadtime' => null,
                'minimum_order_quantity' => null,
                'minimum_purchase_order' => null,
                'address_id' => 10,
                'purchase_order_format' => null,
                'default_pricing_tier_id' => null,
                'default_warehouse_id' => 7,
                'default_shipping_method_id' => null,
                'default_store_id' => null,
                'auto_fulfill_dropship' => 0,
                'auto_submit_dropship_po' => 0,
                'po_processing_method' => 'individually',
                'po_batch_schedule' => null,
                'auto_generate_backorder_po' => 0,
                'auto_submit_backorder_po' => 0,
                'auto_receive_backorder_po' => 0,
                'backorder_po_schedule' => null,
                'default_stock_level' => 'in_stock',
                'default_tax_rate_id' => null,
                'timezone' => Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE),
                'created_at' => '2023-03-26 02:12:38',
                'updated_at' => '2023-03-26 02:14:20',
                'archived_at' => null,
            ],
        ]);
    }
}
