<?php

namespace Database\Seeders\InitialData;

use App\Helpers;
use App\Models\Setting;
use App\Models\Supplier;
use App\Models\SupplierPricingTier;
use App\Repositories\WarehouseRepository;
use Illuminate\Database\Seeder;

class SupplierSeeder extends Seeder
{
    private WarehouseRepository $warehouseRepository;

    public function __construct()
    {
        $this->warehouseRepository = app(WarehouseRepository::class);
    }

    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Supplier::query()->firstOr(function () {
            /** @var SupplierPricingTier $supplierPricingTier */
            $supplierPricingTier = SupplierPricingTier::query()->firstOrCreate(['is_default' => 1], [
                'name' => 'Wholesale',
                'currency_code' => 'USD',
            ]);

            /** @var Supplier $supplier */
            $supplier = Supplier::query()->create([
                'name' => 'Default Supplier',
                'default_pricing_tier_id' => $supplierPricingTier->id,
                'timezone' => Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE)
            ]);
            $this->warehouseRepository->createDefaultWarehouseForSupplier($supplier);

            $supplier->attachPricingTiers([$supplierPricingTier->id]);
        });
    }
}
