<?php

namespace Database\Seeders\InitialData;

use App\Models\Setting;
use App\Models\ShippingCarrier;
use App\Models\ShippingMethod;
use Illuminate\Database\Seeder;

class ShippingCarriersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        ShippingCarrier::query()->firstOr(function () {
            /*
            |--------------------------------------------------------------------------
            | UPS
            |--------------------------------------------------------------------------
            */
            /** @var ShippingCarrier $upsCarrier */
            $upsCarrier = ShippingCarrier::query()->create([
                'name' => 'UPS',
                'tracking_link' => 'https://www.ups.com/mobile/track?trackingNumber=',
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => '2nd Day Air'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 2,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => '2nd Day Air AM'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 2,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => '2nd Day Air International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 2,
                'delivery_max' => 2,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => '3 Day Select'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 3,
                'delivery_max' => 3,
            ]);
            /** @var ShippingMethod $upsGroundMethod */
            $upsGroundMethod = $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Ground'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 3,
                'delivery_max' => 5,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Ground International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 3,
                'delivery_max' => null,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Next Day Air'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Next Day Air Early AM'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Next Day Air International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Next Day Air Saver'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Standard International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 3,
                'delivery_max' => null,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Worldwide Expedited'], [
                'included_locations' => ['Worldwide'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 2,
                'delivery_max' => 5,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Worldwide Express'], [
                'included_locations' => ['Worldwide'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Worldwide Express Plus'], [
                'included_locations' => ['Worldwide'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $upsCarrier->shippingMethods()->updateOrCreate(['name' => 'Worldwide Saver'], [
                'included_locations' => ['Worldwide'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);

            // Make "UPS Ground" the default domestic shipping method
            Setting::with([])->updateOrCreate(['key' => Setting::KEY_SO_DEFAULT_SM_DOMESTIC],
                [
                    'description' => 'Default Shipping Method (Domestic)',
                    'type' => Setting::TYPE_INTEGER,
                    'value' => $upsGroundMethod->id,
                    'default_value' => $upsGroundMethod->id,
                ]);

            // Make "UPS Ground" the default purchase order shipping method
            Setting::with([])->updateOrCreate(['key' => Setting::KEY_PO_DEFAULT_SHIPPING_METHOD],
                [
                    'description' => 'Default Purchase Order Shipping Method',
                    'type' => Setting::TYPE_INTEGER,
                    'value' => $upsGroundMethod->id,
                    'default_value' => $upsGroundMethod->id,
                ]);

            // Make "UPS Ground" the default warehouse transfer shipping method
            Setting::with([])->updateOrCreate(['key' => Setting::KEY_WH_TRANSFER_SHIPPING_METHOD],
                [
                    'description' => 'Warehouse Transfer shipping method',
                    'type' => Setting::TYPE_INTEGER,
                    'value' => $upsGroundMethod->id,
                    'default_value' => $upsGroundMethod->id,
                ]);

            /*
            |--------------------------------------------------------------------------
            | FedEx
            |--------------------------------------------------------------------------
            */
            /** @var ShippingCarrier $fedexCarrier */
            $fedexCarrier = ShippingCarrier::query()->create(
                [
                    'name' => 'FedEx',
                    'tracking_link' => 'https://www.fedex.com/fedextrack/?trknbr=',
                ]
            );
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => '1 Day Freight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => '2 Day Freight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 2,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => '2 Day'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 2,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => '2 Day AM'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 2,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => '3 Day Freight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 3,
                'delivery_max' => 3,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'Express Saver'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 3,
                'delivery_max' => 3,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'First Overnight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'First Overnight Freight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 1,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'Ground'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 3,
                'delivery_max' => 7,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'Ground International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 2,
                'delivery_max' => 7,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'Home Delivery'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 3,
                'delivery_max' => 7,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'International Economy'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 2,
                'delivery_max' => 5,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'International Economy Freight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 5,
                'delivery_max' => 5,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'International First'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'International Priority'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'International Priority Freight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'Priority Overnight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $fedexCarrier->shippingMethods()->updateOrCreate(['name' => 'Standard Overnight'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);

            /*
            |--------------------------------------------------------------------------
            | USPS
            |--------------------------------------------------------------------------
            */
            /** @var ShippingCarrier $uspsCarrier */
            $uspsCarrier = ShippingCarrier::query()->create(
                [
                    'name' => 'USPS',
                    'tracking_link' => 'https://tools.usps.com/go/TrackConfirmAction_input?strOrigTrackNum=',
                ]
            );
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'First Class Mail'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'First Class Mail International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 7,
                'delivery_max' => 21,
            ]);
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'Media Mail'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 8,
            ]);
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'Parcel Select'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 2,
                'delivery_max' => 8,
            ]);
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'Priority Mail'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 3,
            ]);
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'Priority Mail Express'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_DOMESTIC,
                'delivery_min' => 1,
                'delivery_max' => 2,
            ]);
            $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'Priority Mail Express International'], [
                'included_locations' => ['US'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 3,
                'delivery_max' => 5,
            ]);
            /** @var ShippingMethod $uspsPriorityMailInternationalMethod */
            $uspsPriorityMailInternationalMethod = $uspsCarrier->shippingMethods()->updateOrCreate(['name' => 'Priority Mail International'], [
                'included_locations' => ['Worldwide'],
                'type' => ShippingMethod::TYPE_INTERNATIONAL,
                'delivery_min' => 6,
                'delivery_max' => 10,
            ]);

            // Make Default USPS Priority Mail International
            Setting::with([])->updateOrCreate(['key' => Setting::KEY_SO_DEFAULT_SM_INTERNATIONAL],
                [
                    'description' => 'Default Shipping Method (International)',
                    'type' => Setting::TYPE_INTEGER,
                    'value' => $uspsPriorityMailInternationalMethod->id,
                    'default_value' => $uspsPriorityMailInternationalMethod->id,
                ]);
        });

        /*
        |--------------------------------------------------------------------------
        | Pickup
        |--------------------------------------------------------------------------
        */
        // Pickup must always exist
        /** @var ShippingCarrier $pickup */
        $pickup = ShippingCarrier::query()->updateOrCreate(['name' => 'None']);
        $pickup->shippingMethods()->updateOrCreate(['name' => 'Pickup'], [
            'type' => ShippingMethod::TYPE_BOTH,
        ]);
    }
}
