<?php

namespace Database\Seeders\InitialData;

use App\Models\PaymentType;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Database\Seeder;

class PaymentTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Find a valid user ID from the users table
        $userId = User::query()->value('id');

        // If no payment type exists, create some default ones and set related default settings
        PaymentType::query()->firstOr(function () use ($userId) {
            /** @var PaymentType $paymentTypeCash */
            $paymentTypeCash = PaymentType::query()->create([
                'name' => PaymentType::PAYMENT_TYPE_CASH,
                'user_id' => $userId, // Set the user ID to a valid user ID
            ]);

            PaymentType::query()->create([
                'name' => PaymentType::SALES_CREDIT_PAYMENT_TYPE_NAME,
                'user_id' => $userId, // Set the user ID to a valid user ID
            ]);

            Setting::query()->updateOrCreate(['key' => Setting::KEY_SO_DEFAULT_PAYMENT_TYPE],
                [
                    'description' => 'Default Sales Order Payment Type',
                    'type' => Setting::TYPE_INTEGER,
                    'value' => $paymentTypeCash->id,
                    'default_value' => $paymentTypeCash->id,
                ]);

            Setting::with([])->updateOrCreate(['key' => Setting::KEY_PO_DEFAULT_PAYMENT_TYPE],
                [
                    'description' => 'Default Purchase Order Payment Type',
                    'type' => Setting::TYPE_INTEGER,
                    'value' => $paymentTypeCash->id,
                    'default_value' => $paymentTypeCash->id,
                ]);
        });
    }
}
