<?php

namespace Database\Seeders\InitialData;

use App\Models\NominalCode;
use App\Models\Setting;
use Illuminate\Database\Seeder;

class NominalCodesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // If no nominal codes exist, create default ones with default mappings (in settings)
        NominalCode::query()->firstOr(function () {
            /** @var NominalCode $nominalCodeSales */
            $nominalCodeSales = NominalCode::query()->create([
                'code' => 400,
                'type' => NominalCode::TYPE_SALES,
                'name' => 'Sales',
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_SALES_ORDERS,
                'description' => 'Sales Orders',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeSales->id,
            ]);

            // Using COGS instead
            //            Setting::query()->create([
            //                'key'           => Setting::KEY_NC_MAPPING_CN_SALES_ORDERS,
            //                'description'   => 'Credit Notes on Sales Orders',
            //                'type'          => Setting::TYPE_INTEGER,
            //                'value'         => $nominalCodeSales->id,
            //            ]);

            // Not currently used
            //            Setting::query()->create([
            //                'key'           => Setting::KEY_NC_MAPPING_TAX_SALES_ORDERS,
            //                'description'   => 'Tax on Sales Orders',
            //                'type'          => Setting::TYPE_INTEGER,
            //                'value'         => $nominalCodeSales->id,
            //            ]);

            // Used for sales channel integrations TODO: Add Shopify
            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_SHIPPING_SALES_ORDERS,
                'description' => 'Shipping Revenue from Sales Orders',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeSales->id,
            ]);

            /** @var NominalCode $nominalCodeCogs */
            $nominalCodeCogs = NominalCode::query()->create([
                'code' => 500,
                'type' => NominalCode::TYPE_DIRECTCOSTS,
                'name' => 'Cost of Goods Sold',
            ]);

            // Not yet implemented
            //            Setting::query()->create([
            //                'key'           => Setting::KEY_NC_MAPPING_CN_PURCHASE_ORDERS,
            //                'description'   => 'Credit Notes on Purchase Orders',
            //                'type'          => Setting::TYPE_INTEGER,
            //                'value'         => $nominalCodeCogs->id,
            //            ]);

            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_COGS,
                'description' => 'Cost of Goods Sold',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeCogs->id,
            ]);

            /** @var NominalCode $nominalCodeInventory */
            $nominalCodeInventory = NominalCode::query()->create([
                'code' => 100,
                'type' => NominalCode::TYPE_CURRENT,
                'name' => 'Inventory',
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_INVENTORY_CONTROL,
                'description' => 'Inventory Control',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeInventory->id,
            ]);

            /** @var NominalCode $nominalCodeAccruedPurchases */
            $nominalCodeAccruedPurchases = NominalCode::query()->create([
                'code' => 101,
                'type' => NominalCode::TYPE_CURRENT,
                'name' => 'Accrued Purchases',
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_ACCRUED_PURCHASES,
                'description' => 'Accrued Purchases',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeAccruedPurchases->id,
            ]);

            /** @var NominalCode $nominalCodeRounding */
            $nominalCodeRounding = NominalCode::query()->create([
                'code' => 201,
                'type' => NominalCode::TYPE_CURRENT,
                'name' => 'Rounding',
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_ROUNDING,
                'description' => 'Rounding',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeRounding->id,
            ]);

            /** @var NominalCode $nominalCodeInventoryInTransit */
            $nominalCodeInventoryInTransit = NominalCode::query()->create([
                'code' => 102,
                'type' => NominalCode::TYPE_CURRENT,
                'name' => 'Inventory In Transit',
            ]);

            Setting::query()->create([
                'key' => Setting::KEY_NC_MAPPING_INVENTORY_IN_TRANSIT,
                'description' => 'Inventory In Transit',
                'type' => Setting::TYPE_INTEGER,
                'value' => $nominalCodeInventoryInTransit->id,
            ]);

            // Not currently used, no impact in UI
            //            /** @var NominalCode $nominalCodePrepayments */
            //            $nominalCodePrepayments = NominalCode::query()->create([
            //                'code' => 130,
            //                'type' => NominalCode::TYPE_EXPENSE,
            //                'name' => 'Prepayments',
            //            ]);
            //
            //            Setting::query()->create([
            //                'key'           => Setting::KEY_NC_MAPPING_CN_CUSTOMERS,
            //                'description'   => 'Credit Notes for Customers',
            //                'type'          => Setting::TYPE_INTEGER,
            //                'value'         => $nominalCodePrepayments->id,
            //            ]);

            // Not currently used, no impact in UI
            //            /** @var NominalCode $nominalCodeSupplierCredit */
            //            $nominalCodeSupplierCredit = NominalCode::query()->create([
            //                'code' => 121,
            //                'type' => NominalCode::TYPE_EXPENSE,
            //                'name' => 'Supplier Credit',
            //            ]);
            //
            //            Setting::query()->create([
            //                'key'           => Setting::KEY_NC_MAPPING_CN_SUPPLIERS,
            //                'description'   => 'Credit Notes for Suppliers',
            //                'type'          => Setting::TYPE_INTEGER,
            //                'value'         => $nominalCodeSupplierCredit->id,
            //            ]);
        });
    }
}
